/*
 * DateUtil.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

 /**
  * t[eBeBNXB
  * @author Jianming Guo
  */
public class DateUtil {
	/** ftH[g̓tH[}bg */
	public static final String DEFAUL_PATTERN =  "yyyy/MM/dd HH:mm:ss";

	/** ftH[g̓tH[}bg */
	public static final String DEFAUL_TIMESTAMP_PATTERN =  "yyyy/MM/dd HH:mm:ss.SSS";

	/**
	 * t^Ƀp[X܂B
	 *
	 * @param value p[X镶
	 * @return p[X̓t
	 * @exception ParseException p[XɎsꍇɔ܂B
	 */
	public static Date parseDate( String value ) throws ParseException{
		return parseDate(value, DEFAUL_PATTERN, true);
	}

	/**
	 * t^Ƀp[X܂B
	 *
	 * @param value  p[X镶
	 * @param format tH[}bg
	 * @return p[X̓t
	 * @exception ParseException p[XɎsꍇɔ܂B
	 */
	public static Date parseDate(String value, String format) throws ParseException {
		return parseDate(value, format, true);
	}

	/**
	 * t^Ƀp[X܂B
	 *
	 * @param value  p[X镶
	 * @param format tH[}bg
	 * @param lenient truȅꍇ͌ł͂Ȃ
	 * @return p[X̓t
	 * @exception ParseException p[XɎsꍇɔ܂B
	 */
	public static Date parseDate(String value, String format, boolean lenient) throws ParseException {
		SimpleDateFormat df = new SimpleDateFormat(format);
		df.setLenient(lenient);

		return value != null ? df.parse(value) : null;
	}

	/**
	 * ttH[}bg܂B
	 *
	 * @param date tH[}bgt
	 * @return tH[}bg̕
	 * @throws IllegalArgumentException w肳ꂽŃtH[}bgłȂꍇɔ܂B
	 */
	public static String formatDate(java.util.Date date) throws IllegalArgumentException {
		return formatDate(date, DEFAUL_PATTERN);
	}

	/**
	 * ttH[}bg܂B
	 *
	 * @param date tH[}bgt
	 * @param format tH[}bg
	 * @return tH[}bg̕
	 * @throws IllegalArgumentException w肳ꂽŃtH[}bgłȂꍇɔ܂B
	 */
	public static String formatDate(java.util.Date date, String format) throws IllegalArgumentException {
		SimpleDateFormat df;

		if (date == null) {
			return null;
		}

		if (format != null) {
			df = new SimpleDateFormat(format);
		} else {
			// tH[}bgw̏ꍇ
			df = new SimpleDateFormat(DEFAUL_PATTERN);
		}

		return format != null ? df.format(date) : df.format(date);
	}

	/**
	 * TimestamptH[}bg܂B
	 *
	 * @param timestamp tH[}bgTimestamp
	 * @return tH[}bg̕
	 * @throws IllegalArgumentException w肳ꂽŃtH[}bgłȂꍇɔ܂B
	 */
	public static String formatTimestamp(java.sql.Timestamp timestamp) throws IllegalArgumentException {
		return formatTimestamp(timestamp, DEFAUL_TIMESTAMP_PATTERN);
	}

	/**
	 * TimestamptH[}bg܂B
	 *
	 * @param timestamp tH[}bgTimestamp
	 * @param format tH[}bg
	 * @return tH[}bg̕
	 * @throws IllegalArgumentException w肳ꂽŃtH[}bgłȂꍇɔ܂B
	 */
	public static String formatTimestamp(java.sql.Timestamp timestamp, String format) throws IllegalArgumentException {
		SimpleDateFormat df;

		if (timestamp == null) {
			return null;
		}

		if (format != null) {
			df = new SimpleDateFormat(format);
		} else {
			// tH[}bgw̏ꍇ
			df = new SimpleDateFormat(DEFAUL_TIMESTAMP_PATTERN);
		}

		return format != null ? df.format(timestamp) : df.format(timestamp);
	}
}
