/*
 * ValidationEntityResolver.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util;

import java.net.URL;

import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * XMLXL[}GeBeBNXB
 *
 * @author Jianming Guo
 */
public class ValidationEntityResolver implements EntityResolver {

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** XMLXL[}t@CpX */
	private static final String SCHEMA_FILE_PATH = "schema/";

	/** XMLt@C(G[bZ[Wp) */
	private URL xmlFile = null;

	/**
	 * XMLXL[}t@C\[XԂ܂B
	 *
	 * @param publicId QƂĂGeBeB̎ID
	 * @param systemId QƂĂGeBeB̃VXeID
	 * @return XMLXL[}t@CURL
	 * @exception SAXException p[TȌꍇ
	 * @exception ConfigFileDefinitionException ݒt@CɎw肵ĂXMLXL[}t@CȂꍇ
	 */
	public InputSource resolveEntity(String publicId, String systemId)
		throws SAXException, ConfigFileDefinitionException {
		String entityURL = null;

		if (publicId != null) {
			entityURL = publicId;
		}

		if (entityURL == null && systemId != null) {
			// t@Ĉ݂擾
			entityURL = systemId.substring(systemId.lastIndexOf('/') + 1);
		}

		if (entityURL == null) {
			throw new ConfigFileDefinitionException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.UTIL_009, LogMessageConstant.CB3_UTIL_001, this.xmlFile,
					".xsd"));
		}

		// XMLXL[}t@CURL쐬
		URL url = ValidationEntityResolver.class.getClassLoader().
						getResource(SCHEMA_FILE_PATH  + entityURL);
		if (url == null) {
			throw new ConfigFileDefinitionException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.UTIL_010, LogMessageConstant.CB3_UTIL_001, this.xmlFile,
					entityURL));
		}

		try {
			return new InputSource(url.toString());
		} catch (Exception e) {
			throw new ConfigFileDefinitionException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.UTIL_011, LogMessageConstant.CB3_UTIL_001, this.xmlFile,
					entityURL), e);
		}
	}

	/**
	 * XMLt@Cݒ肵܂B
	 *
	 * @param xmlFile XMLt@C
	 */
	public void setXmlFile(URL xmlFile) {
		this.xmlFile = xmlFile;
	}
}
