/*
 * CB3JdbcTemplateTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

import jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate;
import jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig;
import jp.co.cybec.cb3.accessor.dbaccess.DBQueryParameterMap;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.dao.DataAccessException;

/**
 *
 * CB3JdbcTemplateNX̃eXgP[X
 * @author Lijuan Sun
 */
public class CB3JdbcTemplateTest {

	private ApplicationContext context = null;

	private CB3JdbcTemplate cb3JdbcTemplate = null;

	private static String[] CONTEXT_XML_PATH = new String[] {
			"jp/co/cybec/cb3/accessor/dbaccess/TestDBAccessConfig.xml",
			"datasourceContext.xml",
			"transactionContext.xml"
		};

	private DBQueryParameterMap parameter = null;
	//  SQLLbV
	private Map<String, String> sqlCache = new HashMap<String,String>();

	@Before
	public void setup(){
		//CX^X쐬
		context = new ClassPathXmlApplicationContext(CONTEXT_XML_PATH);
		cb3JdbcTemplate = (CB3JdbcTemplate) context.getBean("CB3JdbcTemplate");

		// ݒt@Cǂݍ
		DBAccessConfig info = (DBAccessConfig) ConfigurationLoader
		.load("dbaccessConfigRule.xml","jp/co/cybec/cb3/accessor/dbaccess/dbaccessConfig.xml");

		// NG[pSQL
		for (int i=0; i<info.getSelectSql().size(); i++) {
			sqlCache.put(info.getSelectSql().get(i).getId(),
			 info.getSelectSql().get(i).getSelect());
		}
		// XVpSQL
		for (int i=0; i<info.getUpdateSql().size(); i++) {
			sqlCache.put(info.getUpdateSql().get(i).getId(),
			 info.getUpdateSql().get(i).getUpdate());
		}
		//CT[gpSQL
		for (int i=0; i<info.getInsertSql().size(); i++) {
			sqlCache.put(info.getInsertSql().get(i).getId(),
			 info.getInsertSql().get(i).getInsert());
		}
		// 폜pSQL
		for (int i=0; i<info.getDeleteSql().size(); i++) {
			sqlCache.put(info.getDeleteSql().get(i).getId(),
			 info.getDeleteSql().get(i).getDelete());
		}

		// e[uNA
		cb3JdbcTemplate.update(sqlCache.get("delete1"));
		// p[^ݒ肷
		parameter = new DBQueryParameterMap();
		parameter.put("EMP_NAME", "abcde");
		parameter.put("EMP_CELLULAR_PHONE", "123456789");
		parameter.put("EMP_BIRTH", "19800101");
		parameter.put("EMP_SEX", "1");

	}

	@After
	public void teardown(){
		cb3JdbcTemplate.close();
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate} ̂߂̃eXgE\bhB
	 *
	 */
	@Test
	public void testGetJdbcTemplate() {
		Assert.assertNotNull(cb3JdbcTemplate.getJdbcTemplate());

	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate} ̂߂̃eXgE\bhB
	 * N[YeXg
	 */
	@Test
	public void testClose() {
		try {
			// p[^ݒ肷
			parameter.put("EMP_CODE", "tst01");

			// f[^CT[g
			cb3JdbcTemplate.update(sqlCache.get("insert1"), parameter);
			// f[^擾
			ResultSet rs = cb3JdbcTemplate.query(sqlCache.get("select1"), parameter);
			// N[Y
			cb3JdbcTemplate.close();

			rs.next();
		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof SQLException)){
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate} ̂߂̃eXgE\bhB
	 * p[^tꍇ
	 * NAeXg
	 *
	 */
	@Test
	public void testQueryStringMapOfStringObject01() {
		try {

			// p[^ݒ肷
			parameter.put("EMP_CODE", "tst01");

			// f[^CT[g
			cb3JdbcTemplate.update(sqlCache.get("insert1"), parameter);
			// f[^擾
			ResultSet rs = cb3JdbcTemplate.query(sqlCache.get("select1"), parameter);
			// ʃ`FbN
			Assert.assertNotNull(rs);

			if(rs.next()){
				Assert.assertEquals("tst01", rs.getString("EMP_CODE"));
				Assert.assertEquals("abcde", rs.getString("EMP_NAME"));
				Assert.assertEquals(DateFormat.getDateInstance().parse("1980/01/01"), rs.getDate("EMP_BIRTH"));
			} else {
				Assert.fail("eXgs");
			}
		} catch (SQLException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		} catch (ParseException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate} ̂߂̃eXgE\bhB
	 * p[^tꍇ
	 * NG[G[eXg
	 *
	 */
	@Test
	public void testQueryStringMapOfStringObject02() {
		try {
			// p[^ݒ肷
			parameter.put("EMP_CODE", "tst01");
			// f[^CT[g
			cb3JdbcTemplate.update(sqlCache.get("insert1"), parameter);
			// f[^擾
			cb3JdbcTemplate.query("select * from", parameter);

		} catch(Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate} ̂߂̃eXgE\bhB
	 * p[^tȂꍇ
	 * NG[eXg
	 *
	 */
	@Test
	public void testQueryString01() {
		try {
		   	// p[^ݒ肷
			parameter.put("EMP_CODE", "tst01");

			// f[^CT[g
			cb3JdbcTemplate.update(sqlCache.get("insert1"), parameter);
			// 擾
			ResultSet rs = cb3JdbcTemplate.query(sqlCache.get("select2"));
			// ʃ`FbN
			Assert.assertNotNull(rs);
			if(rs.next()){
				Assert.assertEquals(1, rs.getInt("count"));
			}
		} catch (SQLException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate} ̂߂̃eXgE\bhB
	 * p[^tȂꍇ
	 * NG[G[eXg
	 *
	 */
	@Test
	public void testQueryString02() {
		try {
			// 擾
			cb3JdbcTemplate.query(sqlCache.get("select3"));

		} catch(Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate} ̂߂̃eXgE\bhB
	 * p[^tꍇ
	 * CT[geXg
	 */
	@Test
	public void testUpdateStringMapOfStringObject01() {

	   	// p[^ݒ肷
		parameter.put("EMP_CODE", "tst01");

		// f[^CT[g
		// ʃ`FbN
		Assert.assertEquals(1, cb3JdbcTemplate.update(sqlCache.get("insert1"), parameter));
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate} ̂߂̃eXgE\bhB
	 * p[^tꍇ
	 * CT[gG[eXg
	 */
	@Test
	public void testUpdateStringMapOfStringObject02() {

		try{
		   	// p[^ݒ肷
			parameter.put("EMP_CODE", "tst01");

			// f[^CT[g
			cb3JdbcTemplate.update(sqlCache.get("insert1"), parameter);

		}catch(Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate} ̂߂̃eXgE\bhB
	 * p[^tȂꍇ
	 * 폜eXg
	 */
	@Test
	public void testUpdateString01() {

		String code = null;
	   	// p[^ݒ肷
		for(int i=0; i<5; i++){
			code = "tst0" + String.valueOf(i);
			parameter.put("EMP_CODE", code);
			Assert.assertEquals(1,cb3JdbcTemplate.update(sqlCache.get("insert1"), parameter));
		}
		// ʃ`FbN
		Assert.assertEquals(5,cb3JdbcTemplate.update(sqlCache.get("delete1")));
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate} ̂߂̃eXgE\bhB
	 * p[^tȂꍇ
	 * 폜G[eXg
	 *
	 */
	@Test
	public void testUpdateString02() {

		try{
		   	// p[^ݒ肷
			Assert.assertEquals(1,cb3JdbcTemplate.update("delete * from"));
		}catch(Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcTemplate} ̂߂̃eXgE\bhB
	 * R~bgeXg
	 *
	 */
	@Test
	public void testCommit01() {
		// key
		String code = null;
		try{

			for(int i=0; i<5; i++){
				if (i==4){
					// ܌ڃG[
					code = "tst01";
				} else{
					code = "tst0" + String.valueOf(i);
				}
				parameter.put("EMP_CODE", code);
				Assert.assertEquals(1,cb3JdbcTemplate.update(sqlCache.get("insert1"), parameter));
				if (i==3){
					//SR~bg
					cb3JdbcTemplate.commit();
				}
			}
		}catch(Exception e){
			if (!(e instanceof DataAccessException)){
				Assert.fail("eXgs");
			}
		} finally{
			// ʃ`FbN
			Assert.assertEquals(4,cb3JdbcTemplate.update(sqlCache.get("delete1")));
		}
	}

}
