/*
 * InsertSqlTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import jp.co.cybec.cb3.accessor.dbaccess.InsertSql;
import junit.framework.Assert;

import org.junit.Test;



/**
 *
 * InsertSqlNX̃eXgP[X
 * @author Lijuan Sun
 */
public class InsertSqlTest{

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.InsertSql} ̂߂̃eXgE\bhB
	 * IDw肳ꍇ
	 */
	@Test
	public void testGetId001() {

		InsertSql intSql = new InsertSql();

		intSql.setId("select001");
		Assert.assertEquals("select001",intSql.getId());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.InsertSql} ̂߂̃eXgE\bhB
	 * ID󕶎w肳ꍇ
	 */
	@Test
	public void testGetId002() {

		InsertSql intSql = new InsertSql();

		intSql.setId("");
		Assert.assertEquals("",intSql.getId());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.InsertSql} ̂߂̃eXgE\bhB
	 * IDnullw肳ꍇ
	 */
	@Test
	public void testGetId003() {

		InsertSql intSql = new InsertSql();

		intSql.setId(null);
		Assert.assertNull(intSql.getId());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.InsertSql} ̂߂̃eXgE\bhB
	 * IDw肳ꍇ
	 */
	@Test
	public void testSetId() {

		InsertSql intSql = new InsertSql();

		intSql.setId("select002");
		Assert.assertEquals("select002",intSql.getId());
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.InsertSql} ̂߂̃eXgE\bhB
	 * IDw肳ꍇ
	 */
	@Test
	public void testGetInsert001() {

		InsertSql intSql = new InsertSql();

		intSql.setInsert("select * from EMPLOYEE");
		Assert.assertEquals("select * from EMPLOYEE",intSql.getInsert());
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.InsertSql} ̂߂̃eXgE\bhB
	 * SQL󕶎w肳ꍇ
	 */
	@Test
	public void testGetInsert002() {

		InsertSql intSql = new InsertSql();

		intSql.setInsert("");
		Assert.assertEquals("",intSql.getInsert());

	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.InsertSql} ̂߂̃eXgE\bhB
	 * SQLnullw肳ꍇ
	 */
	@Test
	public void testGetInsert003() {

		InsertSql intSql = new InsertSql();

		intSql.setInsert(null);
		Assert.assertNull(intSql.getInsert());

	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.InsertSql} ̂߂̃eXgE\bhB
	 * SQLw肳ꍇ
	 */
	@Test
	public void testSetInsert() {

		InsertSql intSql = new InsertSql();

		intSql.setInsert("");
		Assert.assertEquals("",intSql.getInsert());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DeleteSql} ̂߂̃eXgE\bhB
	 * R~bgPʂw肳ꍇ
	 */
	public void testGetCommitLimitCount001(){

		String count = "5";
		InsertSql delSql = new InsertSql();
		delSql.setCommitLimitCount(count);
		Assert.assertEquals("5", delSql.getCommitLimitCount());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DeleteSql} ̂߂̃eXgE\bhB
	 * R~bgPʂnullw肳ꍇ
	 */
	public void testGetCommitLimitCount002(){

		String count = null;
		InsertSql delSql = new InsertSql();
		delSql.setCommitLimitCount(count);
		Assert.assertNull(delSql.getCommitLimitCount());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DeleteSql} ̂߂̃eXgE\bhB
	 * R~bgPʂ󕶎w肳ꍇ
	 */
	public void testGetCommitLimitCount003(){

		String count = "";
		InsertSql delSql = new InsertSql();
		delSql.setCommitLimitCount(count);
		Assert.assertEquals("",delSql.getCommitLimitCount());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DeleteSql} ̂߂̃eXgE\bhB
	 * R~bgPʂw肳ꍇ
	 */
	public void testSetCommitLimitCount001(){

		String count = "5";
		InsertSql delSql = new InsertSql();
		delSql.setCommitLimitCount(count);
		Assert.assertEquals("5", delSql.getCommitLimitCount());
	}
}
