/*
 * JdbcRecordReaderTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl;
import jp.co.cybec.cb3.accessor.dbaccess.DBQueryParameterMap;
import jp.co.cybec.cb3.accessor.dbaccess.DBRecordReader;
import jp.co.cybec.cb3.accessor.dbaccess.JdbcRecordReader;
import jp.co.cybec.cb3.mock.accessor.MockResultSet;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.dao.DataAccessException;

/**
 *
 * JdbcRecordReaderNX̃eXgP[X
 * @author Lijuan Sun
 */
public class JdbcRecordReaderTest{

	// ϐ
	ApplicationContext context = null;
	DBAccessorImpl dbaccessTmp;
	DBQueryParameterMap parameter = null;

	// ݒt@Cp[X
	private static String[] CONTEXT_XML_PATH = new String[] {
			"jp/co/cybec/cb3/accessor/dbaccess/TestDBAccessConfig.xml",
			"datasourceContext.xml",
	};

	@Before
	public void setup(){

		// NXCX^X
		context = new ClassPathXmlApplicationContext(CONTEXT_XML_PATH);
		dbaccessTmp = (DBAccessorImpl) context.getBean("dbAccessorImpl");
		// ݒt@Cǂݍ
		dbaccessTmp.initialize("jp/co/cybec/cb3/accessor/dbaccess/dbaccessConfig.xml");
		// e[uNA
		dbaccessTmp.delete("delete1");
		// p[^ݒ肷
		parameter = new DBQueryParameterMap();
		parameter.put("EMP_NAME", "abcde");
		parameter.put("EMP_CELLULAR_PHONE", "123456789");
		parameter.put("EMP_BIRTH", "19800101");
		parameter.put("EMP_SEX", "1");
	}

	@After
	public void tearDown(){
		// [X
		dbaccessTmp.release();
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecordReader} ̂߂̃eXgE\bhB
	 * 擾ꍇ
	 */
	@Test
	public void testNextRecord01() {

		 try{
			 // p[^ݒ肷
			parameter.put("EMP_CODE", "tst01");
			// f[^CT[g
			dbaccessTmp.insert("insert1", parameter);
			// f[^擾
			DBRecordReader recordReader = dbaccessTmp.select("select1", parameter);
			// ʂ`FbN
			Assert.assertNotNull(recordReader);
			Assert.assertNotNull(recordReader.nextRecord());
		 } catch (DataAccessException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecordReader} ̂߂̃eXgE\bhB
	 * nullꍇ
	 */
	@Test
	public void testNextRecord02() {

		 try{
			 // p[^ݒ肷
			parameter.put("EMP_CODE", "tst01");
			// f[^CT[g
			dbaccessTmp.insert("insert1", parameter);
			parameter.clear();
			parameter.put("EMP_CODE", "002");
			// f[^擾
			DBRecordReader recordReader = dbaccessTmp.select("select1", parameter);
			// ʂ`FbN
			Assert.assertNull(recordReader.nextRecord());

		 } catch (DataAccessException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecordReader} ̂߂̃eXgE\bhB
	 * G[ꍇ
	 */
	@Test
	public void testNextRecord03() {

		 try{
			 MockResultSet rs = new MockResultSet();
			 DBQueryParameterMap parameter = new DBQueryParameterMap();
			 parameter.put("key", "value");
			 JdbcRecordReader recordReader = new JdbcRecordReader(rs, "SELECT * FROM DUMMY", parameter);
			 recordReader.nextRecord();
			 // OȂꍇAeXgsB
			 Assert.fail();
		 } catch(Exception e){
			 System.out.println(e.getMessage());
			 if (!(e instanceof DataAccessException)){
				 Assert.fail("eXgs");
			 }
		 }
	}
}
