/*
 * JdbcRecordTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Map;

import jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl;
import jp.co.cybec.cb3.accessor.dbaccess.DBQueryParameterMap;
import jp.co.cybec.cb3.accessor.dbaccess.DBRecord;
import jp.co.cybec.cb3.accessor.dbaccess.DBRecordReader;
import jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord;
import jp.co.cybec.cb3.mock.accessor.MockResultSet;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.dao.DataAccessException;

/**
 *
 * JdbcRecordNX̃eXgP[X
 * @author Lijuan Sun
 */
public class JdbcRecordTest{

	// ϐ
	ApplicationContext context = null;
	DBAccessorImpl dbaccessTmp;
	DBQueryParameterMap parameter = null;
	ResultSet rs = null;
	DBRecordReader reader = null;
	DBRecord record = null;

	// ݒt@Cp[X
	private static String[] CONTEXT_XML_PATH = new String[] {
			"jp/co/cybec/cb3/accessor/dbaccess/TestDBAccessConfig.xml",
			"datasourceContext.xml",
	};

	@Before
	public void setup(){

		// NXCX^X
		context = new ClassPathXmlApplicationContext(CONTEXT_XML_PATH);
		dbaccessTmp = (DBAccessorImpl) context.getBean("dbAccessorImpl");
		// ݒt@Cǂݍ
		dbaccessTmp.initialize("jp/co/cybec/cb3/accessor/dbaccess/dbaccessConfig.xml");
		// e[uNA
		dbaccessTmp.delete("delRecordTest");
		// f[^CT[g
		dbaccessTmp.insert("insertRecordTest");
		// R[h擾
		reader = dbaccessTmp.select("selRecordTest");
	}

	@After
	public void teardown(){
		// X
		dbaccessTmp.release();
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * 1R[hMapeXg
	 */
	@Test
	public void testToMap() {

		Map<String,Object> tmp = null;

		while ((record = reader.nextRecord()) != null) {
			tmp = record.toMap();
		}
		// ʃ`FbN
		Assert.assertEquals(10, tmp.size());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * G[ꍇ
	 */
	@Test
	public void testToMap2() {

		try{
			// MockResultSetCX^X
			MockResultSet mrs = new MockResultSet();
			record = new JdbcRecord(mrs, "SELECT * FROM DUMMY", null, 1);
			record.toMap();
			// OȂꍇAeXgs
			Assert.fail();
		} catch (Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("getDateeXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * 1R[hMapeXg
	 */
	@Test
	public void testToMap3() {

		Map<String,Object> tmp = null;

		while ((record = reader.nextRecord()) != null) {
			tmp = record.toMap();
			tmp = record.toMap();
		}
		// ʃ`FbN
		Assert.assertEquals(10, tmp.size());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * 1R[hMapeXg
	 */
	@Test
	public void testToMapStringValue() {

		Map<String,String> tmp = null;

		while ((record = reader.nextRecord()) != null) {
			tmp = record.toMapStringValue();
		}
		// ʃ`FbN
		Assert.assertEquals(10, tmp.size());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * 1R[hMapeXg
	 */
	@Test
	public void testToMapStringValue2() {

		Map<String,String> tmp = null;

		while ((record = reader.nextRecord()) != null) {
			tmp = record.toMapStringValue();
			tmp = record.toMapStringValue();
		}
		// ʃ`FbN
		Assert.assertEquals(10, tmp.size());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * 擾ꍇ
	 */
	@Test
	public void testGetAll(){

		while ((record = reader.nextRecord()) != null) {
			// ʃ`FbN
			Assert.assertEquals(new Integer(1234567890),record.getInteger("INTEGER_COLUMN"));
			Assert.assertEquals(new String("String"), record.getObject("STRING_COLUMN"));
			Assert.assertEquals(new Short("-32768"), record.getShort("SHORT_COLUMN"));
			Assert.assertEquals(new Float("2.40282"), record.getFloat("FLOAT_COLUMN"));
			Assert.assertEquals(new BigDecimal("123456789012345"), record.getBigDecimal("BIGDECIMAL_COLUMN"));
			try {
				Assert.assertEquals(DateFormat.getDateInstance().parse("2008/03/28"), record.getDate("DATE_COLUMN"));
			} catch (ParseException e) {
				e.printStackTrace();
				Assert.fail("getDateeXgs");
			}
			Assert.assertEquals("2008-03-28 14:16:26.0", record.getTimestamp("TIMESTAMP_COLUMN").toString());
			Assert.assertEquals("String", record.getString("STRING_COLUMN"));
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * 擾ꍇ
	 */
	@Test
	public void testGetLong() {
		while ((record = reader.nextRecord()) != null) {
			// ʃ`FbN
			Assert.assertEquals(new Long("9223372036854775807"), record.getLong("LONG_COLUMN"));
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * G[ꍇ
	 */
	@Test
	public void testGetObject(){

		try{
			while ((record = reader.nextRecord()) != null) {
				record.getObject("COLUMN");
			}
			// OȂꍇAeXgs
			Assert.fail();
		} catch (Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("getDateeXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * G[ꍇ
	 */
	@Test
	public void testGetLong2(){

		try{
			while ((record = reader.nextRecord()) != null) {
				record.getLong("COLUMN");
			}
			// OȂꍇAeXgs
			Assert.fail();
		} catch (Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("getDateeXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * G[ꍇ
	 */
	@Test
	public void testGetInteger(){

		try{
			while ((record = reader.nextRecord()) != null) {
				record.getInteger("COLUMN");
			}
		} catch (Exception e){
			if (!(e instanceof DataAccessException)){
				Assert.fail("getDateeXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * G[ꍇ
	 */
	@Test
	public void testGetShort(){

		try{
			while ((record = reader.nextRecord()) != null) {
				record.getShort("COLUMN");
			}
		} catch (Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("getDateeXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * G[ꍇ
	 */
	@Test
	public void testGetFloat(){

		try{
			while ((record = reader.nextRecord()) != null) {
				record.getFloat("COLUMN");
			}
			// OȂꍇAeXgs
			Assert.fail();
		} catch (Exception e){
			if (!(e instanceof DataAccessException)){
				Assert.fail("getDateeXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * G[ꍇ
	 */
	@Test
	public void testGetDate(){

		try{
			while ((record = reader.nextRecord()) != null) {
				record.getDate("COLUMN");
			}
			// OȂꍇAeXgs
			Assert.fail();
		} catch (Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("getDateeXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * G[ꍇ
	 */
	@Test
	public void testGetBigDecimal(){

		try{
			while ((record = reader.nextRecord()) != null) {
				record.getBigDecimal("COLUMN");
			}
			// OȂꍇAeXgs
			Assert.fail();
		} catch (Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("getDateeXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * G[ꍇ
	 */
	@Test
	public void testTimestamp(){

		try{
			while ((record = reader.nextRecord()) != null) {
				record.getTimestamp("COLUMN");
			}
			// OȂꍇAeXgs
			Assert.fail();
		} catch (Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("getDateeXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * G[ꍇ
	 */
	@Test
	public void testGetString(){

		try{
			while ((record = reader.nextRecord()) != null) {
				record.getString("COLUMN");
			}
			// OȂꍇAeXgs
			Assert.fail();
		} catch (Exception e){
			// ʃ`FbN
			if (!(e instanceof DataAccessException)){
				Assert.fail("getDateeXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.JdbcRecord} ̂߂̃eXgE\bhB
	 * 1R[hMapeXg
	 */
	@Test
	public void test() {
		while ((record = reader.nextRecord()) != null) {
			System.out.println(record.toMapStringValue());
		}
	}
}
