/*
 * FlatFileRecordReaderImplTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordReaderImpl;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link FlatFileRecordReaderImpl} ̃eXgP[XB
 * @author Juanjuan Wang
 */
public class FlatFileRecordReaderImplTest {
	/** ǂݍݗp f[^t@C */
	private static final String CVS_FILE_NORMAL= "src/test/testdata/delimited/test.csv";

	// NXCX^X
	FlatFileRecordReaderImpl target = null;

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		target = new FlatFileRecordReaderImpl();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
		target.release();
	}

	/**
	 * {@link FlatFileRecordReaderImpl#open()} ̂߂̃eXgE\bhB
	 * OȂƂmFB
	 */
	@Test
	public void testOpen() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setEncode("Shift_JIS");
		target.open();
	}

	/**
	 * {@link FlatFileRecordReaderImpl#open()} ̂߂̃eXgE\bhB
	 * f[^t@C݂ȂɗO邱ƂmFB
	 */
	@Test(expected = DataFileNotFoundException.class)
	public void testOpenDataFileNotFoundException() {
		target.setFilepath("fileNotFound.txt");
		target.setEncode("Shift_JIS");
		target.open();
	}

	/**
	 * {@link FlatFileRecordReaderImpl#open()} ̂߂̃eXgE\bhB
	 * QI[vƂɗO邱ƂmFB
	 */
	@Test(expected = AccessorAlreadyOpenedException.class)
	public void testOpenAccessorAlreadyOpenedException() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setEncode("Shift_JIS");
		target.open();
		target.open();
	}

	/**
	 * {@link FlatFileRecordReaderImpl#open()} ̂߂̃eXgE\bhB
	 * f[^t@Cnull̎ɗO邱ƂmFB
	 */
	@Test(expected = DataFileNotFoundException.class)
	public void testOpenNullFilepath() {
		target.setFilepath(null);
		target.open();
	}

	/**
	 * {@link FlatFileRecordReaderImpl#open()} ̂߂̃eXgE\bhB
	 * f[^t@C̓ǂݍ݂ɎsɗO邱ƂmFB
	 */
	@Test(expected = DataFileIOException.class)
	public void testOpenDataFileIOException() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setEncode("EUC");
		target.open();
	}

	/**
	 * {@link FlatFileRecordReaderImpl#close()} ̂߂̃eXgE\bhB
	 * OȂƂmFB
	 */
	@Test
	public void testClose() {
	 	target.setFilepath(CVS_FILE_NORMAL);
		target.setEncode("Shift_JIS");

	 	target.open();
	 	target.close();
	 	target.open();
	}


	/**
	 * {@link FlatFileRecordReaderImpl#close()} ̂߂̃eXgE\bhB
	 * t@CI[vĂȂĂAOȂƂmFB
	 */
	@Test
	public void testCloseNoOpen() {
	 	target.setFilepath(CVS_FILE_NORMAL);
		target.setEncode("Shift_JIS");

	 	target.close();
	}

	/**
	 * {@link FlatFileRecordReaderImpl#release()} ̂߂̃eXgE\bhB
	 * OȂƂmFB
	 */
	@Test
	public void testRelease() {
	 	target.setFilepath(CVS_FILE_NORMAL);
		target.setEncode("Shift_JIS");

	 	target.open();
	 	target.release();
	 	target.open();
	}

	/**
	 * {@link FlatFileRecordReaderImpl#isOpen()} ̂߂̃eXgE\bhB
	 * t@CI[vt@C̃I[vԂێtOݒł邱ƂmF邱ƁB
	 */
	@Test
	public void testIsOpenOpen() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setEncode("Shift_JIS");
		target.open();
		Assert.assertEquals(true, target.isOpen());
	}

	/**
	 * {@link FlatFileRecordReaderImpl#isOpen()} ̂߂̃eXgE\bhB
	 * t@CN[Yt@C̃I[vԂێtOݒł邱ƂmF邱ƁB
	 */
	@Test
	public void testIsOpenClose() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setEncode("Shift_JIS");
		target.open();
		target.close();
		Assert.assertEquals(false, target.isOpen());
		target.open();
	}

	/**
	 * {@link FlatFileRecordReaderImpl#getBufferedReader()} ̂߂̃eXgE\bhB
	 * obt@[[_[擾ł邱ƂmFB
	 */
	@Test
	public void testGetBufferedReader() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setEncode("Shift_JIS");
		target.open();
		Assert.assertNotNull(target.getBufferedReader());
	}

	/**
	 * {@link FlatFileRecordReaderImpl#getFilepath()} ̂߂̃eXgE\bhB
	 * t@CpX擾ł邱ƂmF邱ƁB
	 */
	@Test
	public void testGetFilepath() {
		target.setFilepath("d:/test.csv");
		Assert.assertEquals("d:/test.csv", target.getFilepath());
	}

	/**
	 * {@link FlatFileRecordReaderImpl#setFilepath(String)} ̂߂̃eXgE\bhB
	 * t@CpXݒł邱ƂmF邱ƁB
	 */
	@Test
	public void testSetFilepath() {
		target.setFilepath("d:/test.csv");
		Assert.assertEquals("d:/test.csv", target.getFilepath());
	}

	/**
	 * {@link FlatFileRecordReaderImpl#getEncode()} ̂߂̃eXgE\bhB
	 * GR[h擾ł邱ƂmF邱ƁB
	 */
	@Test
	public void testGetEncode() {
		target.setEncode("Shift_JIS");
		Assert.assertEquals("Shift_JIS", target.getEncode());
	}

	/**
	 * {@link FlatFileRecordReaderImpl#setEncode(String)} ̂߂̃eXgE\bhB
	 * GR[hݒł邱ƂmF邱ƁB
	 */
	@Test
	public void testSetEncode() {
		target.setEncode("Shift_JIS");
		Assert.assertEquals("Shift_JIS", target.getEncode());
	}
}
