/*
 * DelimitedLineRecordReaderConfigTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.delimited;

import jp.co.cybec.cb3.accessor.fileaccess.flat.delimited.DelimitedLineRecordFieldConfig;
import jp.co.cybec.cb3.accessor.fileaccess.flat.delimited.DelimitedLineRecordReaderConfig;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link DelimitedLineRecordReaderConfig} ̃eXgP[XB
 * @author Juanjuan Wang
 */
public class DelimitedLineRecordReaderConfigTest {

	DelimitedLineRecordReaderConfig target = null;

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		target = new DelimitedLineRecordReaderConfig();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * {@link DelimitedLineRecordReaderConfig#getFilepath()} ̂߂̃eXgE\bhB
	 * t@CpX擾ł邱ƂmFB
	 */
	@Test
	public void testGetFilepath() {
		target.setFilepath("c:\test.csv");
		Assert.assertEquals("c:\test.csv", target.getFilepath());
	}

	/**
	 * {@link DelimitedLineRecordReaderConfig#setFilepath(String)} ̂߂̃eXgE\bhB
	 * t@CpXݒł邱ƂmFB
	 */
	@Test
	public void testSetFilepath() {
		target.setFilepath("c:\test.csv");
		Assert.assertEquals("c:\test.csv", target.getFilepath());
	}

	/**
	 * {@link DelimitedLineRecordReaderConfig#getFieldList()} ̂߂̃eXgE\bhB
	 * tB[h񃊃Xg擾ł邱ƂmFB
	 */
	@Test
	public void testGetFieldList() {
		DelimitedLineRecordFieldConfig field = new DelimitedLineRecordFieldConfig();
		field.setAlign("left");
		target.addField(field);
		field.setName("name");
		target.addField(field);
		field.setPadding(" ");
		target.addField(field);
		field.setPattern("0");
		target.addField(field);
		field.setPatternClass("pattern_class");
		target.addField(field);
		field.setLength("10");
		target.addField(field);
		field.setType("type");
		target.addField(field);

		// ʂ`FbN
		Assert.assertEquals(7, target.getFieldList().size());
		Assert.assertEquals("left", target.getFieldList().get(0).getAlign());
		Assert.assertEquals("name", target.getFieldList().get(1).getName());
		Assert.assertEquals(" ", target.getFieldList().get(2).getPadding());
		Assert.assertEquals("0", target.getFieldList().get(3).getPattern());
		Assert.assertEquals("pattern_class", target.getFieldList().get(4).getPatternClass());
		Assert.assertEquals("10", target.getFieldList().get(5).getLength());
		Assert.assertEquals("type", target.getFieldList().get(6).getType());
	}

	/**
	 * {@link DelimitedLineRecordReaderConfig#addField(DelimitedLineRecordFieldConfig)} ̂߂̃eXgE\bhB
	 * tB[h񂪃Xgɒǉł邱ƂmFB
	 */
	@Test
	public void testAddField() {
		// ʃf[^
		DelimitedLineRecordFieldConfig field = new DelimitedLineRecordFieldConfig();
		field.setAlign("left");
		target.addField(field);
		field.setName("name");
		target.addField(field);
		field.setPadding(" ");
		target.addField(field);
		field.setPattern("0");
		target.addField(field);
		field.setPatternClass("pattern_class");
		target.addField(field);
		field.setLength("10");
		target.addField(field);
		field.setType("type");
		target.addField(field);

		// ʂ`FbN
		Assert.assertEquals(7, target.getFieldList().size());
		Assert.assertEquals("left", target.getFieldList().get(0).getAlign());
		Assert.assertEquals("name", target.getFieldList().get(1).getName());
		Assert.assertEquals(" ", target.getFieldList().get(2).getPadding());
		Assert.assertEquals("0", target.getFieldList().get(3).getPattern());
		Assert.assertEquals("pattern_class", target.getFieldList().get(4).getPatternClass());
		Assert.assertEquals("10", target.getFieldList().get(5).getLength());
		Assert.assertEquals("type", target.getFieldList().get(6).getType());
	}

	/**
	 * {@link DelimitedLineRecordReaderConfig#getSeparator()} ̂߂̃eXgE\bhB
	 * Zp[^擾ł邱ƂmFB
	 */
	@Test
	public void testGetSeparator() {
		target.setSeparator(",");
		Assert.assertEquals(",", target.getSeparator());
	}

	/**
	 * {@link DelimitedLineRecordReaderConfig#setSeparator(String)} ̂߂̃eXgE\bhB
	 * Zp[^ݒł邱ƂmFB
	 */
	@Test
	public void testSetSeparator() {
		target.setSeparator(",");
		Assert.assertEquals(",", target.getSeparator());
	}

	/**
	 * {@link DelimitedLineRecordReaderConfig#getQuotechar()} ̂߂̃eXgE\bhB
	 * NH[g擾ł邱ƂmFB
	 */
	@Test
	public void testGetQuotechar() {
		target.setQuotechar("'");
		Assert.assertEquals("'", target.getQuotechar());
	}

	/**
	 * {@link DelimitedLineRecordReaderConfig#setQuotechar(String)} ̂߂̃eXgE\bhB
	 * NH[gݒł邱ƂmFB
	 */
	@Test
	public void testSetQuotechar() {
		target.setQuotechar("'");
		Assert.assertEquals("'", target.getQuotechar());
	}

	/**
	 * {@link DelimitedLineRecordReaderConfig#getSkipLines()} ̂߂̃eXgE\bhB
	 * XLbvs擾ł邱ƂmFB
	 */
	@Test
	public void testGetSkipLines() {
		target.setSkipLines(new Integer(1).intValue());
		Assert.assertEquals(new Integer(1).intValue(), target.getSkipLines());
	}

	/**
	 * {@link DelimitedLineRecordReaderConfig#setSkipLines(int)} ̂߂̃eXgE\bhB
	 * XLbvsݒł邱ƂmFB
	 */
	@Test
	public void testSetSkipLines() {
		target.setSkipLines(new Integer(1).intValue());
		Assert.assertEquals(new Integer(1).intValue(), target.getSkipLines());
	}
}
