/*
 * DelimitedLineRecordReaderTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.delimited;

import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.delimited.DelimitedLineRecordReader;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFormatException;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link DelimitedLineRecordReader} ̃eXgP[XB
 * @author Juanjuan Wang
 */
public class DelimitedLineRecordReaderTest {

	/** separatorF","AquotecharF"&quot;"AskipLinesF"1"AencodeF"Shift_JIS"̏ꍇAǂݍݗp t@C */
	private static final String CONFIG_READER1 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/reader/readerConfig1.xml";

	/** separatorF""AquotecharF""AskipLinesF""AencodeF""̏ꍇAǂݍݗp t@C */
	private static final String CONFIG_READER2 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/reader/readerConfig2.xml";

	/** ϒ̃[_[̃~j}Zbg̏ꍇAǂݍݗp t@C */
	private static final String CONFIG_READER3 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/reader/readerConfig3.xml";

	/** separatorF""AquotecharF"&quot;"AskipLinesF""AencodeF"unicode"̏ꍇAǂݍݗp t@C */
	private static final String CONFIG_READER4 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/reader/readerConfig9.xml";

	/** p^[NX̏ꍇAǂݍݗp t@C */
	private static final String CONFIG_READER5 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/reader/readerConfig5.xml";

	/** ݒt@C̃tB[hƃf[^t@C̃tB[hĂ܂B */
	private static final String CONFIG_READER7 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/reader/readerConfig7.xml";

	/** f[^t@C̃tB[hłB */
	private static final String CONFIG_READER8 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/reader/readerConfig8.xml";

	/** [U[`NX݂Ȃ */
	private static final String CONFIG_READER9 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/reader/readerConfig6.xml";

	/** f[^t@C̃GR[hEUCł */
	private static final String CONFIG_READER10 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/reader/readerConfig4.xml";

	/** p^[NX̏ꍇAtH[}bg鎞ɁAO */
	private static final String CONFIG_READER11 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/reader/readerConfig10.xml";

	/** f[^t@C */
	private static final String FILE_NORMAL= "src/test/testdata/delimited/test.csv";

	private DelimitedLineRecordReader delimitedReader = null;
	private FlatFileRecord record = null;

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		delimitedReader = new DelimitedLineRecordReader();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
		delimitedReader.release();
	}

	/**
	 * {@link DelimitedLineRecordReader#initialize(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testInitialize() {
		delimitedReader.initialize(CONFIG_READER1);
	}

	/**
	 * {@link DelimitedLineRecordReader#initialize(String)} ̂߂̃eXgE\bhB<br>
	 * ɑ݂ȂL[iݒt@Cjw肵ƂɗO邱ƂmFB
	 */
	@Test(expected = ConfigFileNotFoundException.class)
	public void testInitializeConfigFileNotFoundException() {
		delimitedReader.initialize("aaa");
	}

	/**
	 * {@link DelimitedLineRecordReader#open(String)} ̂߂̃eXgE\bhB
	 * OȂƂmFB
	 */
	@Test
	public void testOpenString() {
		delimitedReader.initialize(CONFIG_READER1);
		delimitedReader.open(FILE_NORMAL);
	}

	/**
	 * {@link DelimitedLineRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * R[h擾ł邱ƂmFB
	 * separatorF","
	 * quotecharF"&quot;"
	 * skipLinesF"1"
	 * encode   F"Shift_JIS"
	 */
	@Test
	public void testNextRecord01() {
		// ݒt@Cǂݍ
		delimitedReader.initialize(CONFIG_READER1);
		delimitedReader.open();
		// f[^擾
		record = delimitedReader.nextRecord();

		// ʂ`FbN
		Assert.assertEquals("1", record.getString("intField"));
		Assert.assertEquals("teststring\\\"", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.46", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|@\"T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals("", record.getString("strField4"));
		Assert.assertEquals(",", record.getString("strField5"));
		Assert.assertEquals("12_q̃~J", record.getString("strField6"));
		Assert.assertEquals("́@w\r\n", record.getString("strField7"));
		Assert.assertEquals("{cwww.bb@hotmail.com.cn", record.getString("strField8"));
		Assert.assertEquals("10%", record.getString("strField9"));
		Assert.assertEquals("XCJ&B", record.getString("strField10"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));

		record = null;
		record = delimitedReader.nextRecord();

		// ʂ`FbN
		Assert.assertEquals("2", record.getString("intField"));
		Assert.assertEquals("teststring\\\"2", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.4", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|2@\"T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals("", record.getString("strField4"));
		Assert.assertEquals(",", record.getString("strField5"));
		Assert.assertEquals("12_q̃~J", record.getString("strField6"));
		Assert.assertEquals("2́@w\r\n", record.getString("strField7"));
		Assert.assertEquals("{c2www.bb@hotmail.com.cn", record.getString("strField8"));
		Assert.assertEquals("10%", record.getString("strField9"));
		Assert.assertEquals("XCJ&B", record.getString("strField10"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));
	}

	/**
	 * {@link DelimitedLineRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * R[h擾ł邱ƂmFB
	 * separatorF Ȃ
	 * quotecharF Ȃ
	 * skipLinesF Ȃ
	 * encode   F Ȃ
	 */
	@Test
	public void testNextRecord02() {
		// ݒt@Cǂݍ
		delimitedReader.initialize(CONFIG_READER2);
		delimitedReader.open();
		// f[^擾
		record = delimitedReader.nextRecord();
		// ʂ`FbN
		Assert.assertEquals("1", record.getString("intField"));
		Assert.assertEquals("teststring1\\\"", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|1@\"T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals(" ", record.getString("strField4"));
		Assert.assertEquals(" ", record.getString("strField5"));
		Assert.assertEquals(" ", record.getString("strField6"));
		Assert.assertEquals("12_q̃~J", record.getString("strField7"));
		Assert.assertEquals("1́@w", record.getString("strField8"));
		Assert.assertEquals("{c1www.bb@hotmail.com.cn", record.getString("strField9"));
		Assert.assertEquals("10%", record.getString("strField10"));
		Assert.assertEquals("XCJ&B", record.getString("strField11"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));
		record = null;
		record = delimitedReader.nextRecord();
		// ʂ`FbN
		Assert.assertEquals("2", record.getString("intField"));
		Assert.assertEquals("teststring2\\\"", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|2@\"T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals(" ", record.getString("strField4"));
		Assert.assertEquals(" ", record.getString("strField5"));
		Assert.assertEquals(" ", record.getString("strField6"));
		Assert.assertEquals("12_q̃~J", record.getString("strField7"));
		Assert.assertEquals("2́@w", record.getString("strField8"));
		Assert.assertEquals("{c2www.bb@hotmail.com.cn", record.getString("strField9"));
		Assert.assertEquals("10%", record.getString("strField10"));
		Assert.assertEquals("XCJ&B", record.getString("strField11"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));
		record = null;
		record = delimitedReader.nextRecord();
		// ʂ`FbN
		Assert.assertEquals("3", record.getString("intField"));
		Assert.assertEquals("teststring3\\\"", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|3@\"T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals(" ", record.getString("strField4"));
		Assert.assertEquals(" ", record.getString("strField5"));
		Assert.assertEquals(" ", record.getString("strField6"));
		Assert.assertEquals("12_q̃~J", record.getString("strField7"));
		Assert.assertEquals("3́@w", record.getString("strField8"));
		Assert.assertEquals("{c3www.bb@hotmail.com.cn", record.getString("strField9"));
		Assert.assertEquals("10%", record.getString("strField10"));
		Assert.assertEquals("XCJ&B", record.getString("strField11"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));
	}
	/**
	 * {@link DelimitedLineRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * ϒ̃[_[̃~j}Zbg̏ꍇAR[h擾ł邱ƂmFB
	 *
	 */
	@Test
	public void testNextRecord03() {
		// ݒt@Cǂݍ
		delimitedReader.initialize(CONFIG_READER3);
		delimitedReader.open();
		// f[^擾
		record = delimitedReader.nextRecord();

		// ʂ`FbN
		Assert.assertEquals("1", record.getString("intField"));
		Assert.assertEquals("teststring1\\\"", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|1@\"T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals(" ", record.getString("strField4"));
		Assert.assertEquals(" ", record.getString("strField5"));
		Assert.assertEquals(" ", record.getString("strField6"));
		Assert.assertEquals("12_q̃~J", record.getString("strField7"));
		Assert.assertEquals("1́@w", record.getString("strField8"));
		Assert.assertEquals("{c1www.bb@hotmail.com.cn", record.getString("strField9"));
		Assert.assertEquals("10%", record.getString("strField10"));
		Assert.assertEquals("XCJ&B", record.getString("strField11"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));

		record = null;
		// f[^擾
		record = delimitedReader.nextRecord();

		// ʂ`FbN
		Assert.assertEquals("2", record.getString("intField"));
		Assert.assertEquals("teststring2\\\"", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|2@\"T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals(" ", record.getString("strField4"));
		Assert.assertEquals(" ", record.getString("strField5"));
		Assert.assertEquals(" ", record.getString("strField6"));
		Assert.assertEquals("12_q̃~J", record.getString("strField7"));
		Assert.assertEquals("2́@w", record.getString("strField8"));
		Assert.assertEquals("{c2www.bb@hotmail.com.cn", record.getString("strField9"));
		Assert.assertEquals("10%", record.getString("strField10"));
		Assert.assertEquals("XCJ&B", record.getString("strField11"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));

		record = null;
		// f[^擾
		record = delimitedReader.nextRecord();

		// ʂ`FbN
		Assert.assertEquals("3", record.getString("intField"));
		Assert.assertEquals("teststring3\\\"", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|3@\"T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals(" ", record.getString("strField4"));
		Assert.assertEquals(" ", record.getString("strField5"));
		Assert.assertEquals(" ", record.getString("strField6"));
		Assert.assertEquals("12_q̃~J", record.getString("strField7"));
		Assert.assertEquals("3́@w", record.getString("strField8"));
		Assert.assertEquals("{c3www.bb@hotmail.com.cn", record.getString("strField9"));
		Assert.assertEquals("10%", record.getString("strField10"));
		Assert.assertEquals("XCJ&B", record.getString("strField11"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));
	}

	/**
	 * {@link DelimitedLineRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * R[h擾ł邱ƂmFB
	 * separatorFȂ
	 * quotecharF"&quot;"
	 * skipLinesFȂ
	 * encode   Funicode
	 */
	@Test
	public void testNextRecord04() {
		// ݒt@Cǂݍ
		delimitedReader.initialize(CONFIG_READER4);
		delimitedReader.open();
		// f[^擾
		record = delimitedReader.nextRecord();

		// ʂ`FbN
		Assert.assertEquals("1", record.getString("intField"));
		Assert.assertEquals("teststring\\\"", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|@\"T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals("", record.getString("strField4"));
		Assert.assertEquals(",", record.getString("strField5"));
		Assert.assertEquals("12_q\r\ñ~J", record.getString("strField6"));
		Assert.assertEquals("́@w\r\n", record.getString("strField7"));
		Assert.assertEquals("{cwww.bb@hotmail.com.cn", record.getString("strField8"));
		Assert.assertEquals("10%", record.getString("strField9"));
		Assert.assertEquals("XCJ&B", record.getString("strField10"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));

		record = null;
		// f[^擾
		record = delimitedReader.nextRecord();

		// ʂ`FbN
		Assert.assertEquals("2", record.getString("intField"));
		Assert.assertEquals("teststring\\\"", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|@\"T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals("", record.getString("strField4"));
		Assert.assertEquals(",", record.getString("strField5"));
		Assert.assertEquals("12_q̃~J", record.getString("strField6"));
		Assert.assertEquals("́@w", record.getString("strField7"));
		Assert.assertEquals("{cwww.bb@hotmail.com.cn", record.getString("strField8"));
		Assert.assertEquals("10%", record.getString("strField9"));
		Assert.assertEquals("XCJ&B", record.getString("strField10"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));

		record = null;
		// f[^擾
		record = delimitedReader.nextRecord();

		// ʂ`FbN
		Assert.assertEquals("3", record.getString("intField"));
		Assert.assertEquals("teststring\\\"", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|@\"T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals("   @", record.getString("strField4"));
		Assert.assertEquals(",", record.getString("strField5"));
		Assert.assertEquals("12_q̃~J", record.getString("strField6"));
		Assert.assertEquals("́@w", record.getString("strField7"));
		Assert.assertEquals("{cwww.bb@hotmail.com.cn", record.getString("strField8"));
		Assert.assertEquals("10%", record.getString("strField9"));
		Assert.assertEquals("XCJ&B", record.getString("strField10"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));

	}

	/**
	 * {@link DelimitedLineRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * p^[NX̏ꍇAR[h擾ł邱ƂmFB
	 * separatorF ","
	 * quotecharF "&quot;"
	 * skipLinesF "1"
	 * encode   F "UTF-8"
	 */
	@Test
	public void testNextRecord05() {
		// ݒt@Cǂݍ
		delimitedReader.initialize(CONFIG_READER5);
	 	delimitedReader.open();
		// f[^擾
		record = delimitedReader.nextRecord();
		// ʂ`FbN
		Assert.assertEquals("001", record.getString("intField"));
		Assert.assertEquals("teststring", record.getString("strField1"));
		Assert.assertEquals("teststring2", record.getString("strField2"));
		Assert.assertEquals("1456785", record.getString("longField"));
		Assert.assertEquals("123", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/01/02 08:10:12", record.getString("dateField1"));
		Assert.assertEquals("2006/12/23 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("|@T̐ToPQRp", record.getString("strField3"));
		Assert.assertEquals("@", record.getString("strField4"));
		Assert.assertEquals(",", record.getString("strField5"));
		Assert.assertEquals("12_q̃~J", record.getString("strField6"));
		Assert.assertEquals("́@w\r\n", record.getString("strField7"));
		Assert.assertEquals("{cwww.bb@hotmail.com.cn", record.getString("strField8"));
		Assert.assertEquals("10%", record.getString("strField9"));
		Assert.assertEquals("XCJ&B", record.getString("strField10"));
		Assert.assertEquals("2001/10/05 00:00:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 08:44:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 00:00:00", record.getString("dateField5"));
	}

	/**
	 * {@link DelimitedLineRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * f[^t@CI[vĂȂĂOȂƂmFB
	 */
	@Test(expected = AccessorNotOpenException.class)
	public void testNextRecord06() {
		// ݒt@Cǂݍ
		delimitedReader.initialize(CONFIG_READER1);
		delimitedReader.nextRecord();
	}

	/**
	 * {@link DelimitedLineRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * ݒt@C̃tB[hƃf[^t@C̃tB[hĂ܂BO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testNextRecord07() {
		// ݒt@Cǂݍ
		delimitedReader.initialize(CONFIG_READER7);
	 	delimitedReader.open();
	 	delimitedReader.nextRecord();
	}

	/**
	 * {@link DelimitedLineRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * f[^t@C̃tB[h̒̏ꍇAOȂƂmFB
	 */
	@Test
	public void testNextRecord08() {
		// ݒt@Cǂݍ
		delimitedReader.initialize(CONFIG_READER8);
	 	delimitedReader.open();
	 	delimitedReader.nextRecord();
	 	delimitedReader.nextRecord();
	}

	/**
	 * {@link DelimitedLineRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * p^[NX̏ꍇA[U[`NX݂ȂŁAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testNextRecord09() {
		// ݒt@Cǂݍ
		delimitedReader.initialize(CONFIG_READER9);
		delimitedReader.open();
		// f[^擾
		record = delimitedReader.nextRecord();
	}

	/**
	 * {@link DelimitedLineRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * f[^t@C̃GR[hEUC̏ꍇAO邱ƂmFB
	 */
	@Test(expected = DataFileIOException.class)
	public void testNextRecord10() {
		// ݒt@Cǂݍ
		delimitedReader.initialize(CONFIG_READER10);
	 	delimitedReader.open();
	}

	/**
	 * {@link DelimitedLineRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * p^[NX̏ꍇAtH[}bg鎞ɁAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testNextRecord11() {
		// ݒt@Cǂݍ
		delimitedReader.initialize(CONFIG_READER11);
	 	delimitedReader.open();
		// f[^擾
		record = delimitedReader.nextRecord();
	}

}
