/*
 * DelimitedLineRecordWriterConfigTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.delimited;

import jp.co.cybec.cb3.accessor.fileaccess.flat.delimited.DelimitedLineRecordFieldConfig;
import jp.co.cybec.cb3.accessor.fileaccess.flat.delimited.DelimitedLineRecordWriterConfig;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link DelimitedLineRecordWriterConfig} ̃eXgP[XB
 * @author Juanjuan Wang
 */
public class DelimitedLineRecordWriterConfigTest {
	private DelimitedLineRecordWriterConfig target = null;

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		target = new DelimitedLineRecordWriterConfig();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#getFilepath()} ̂߂̃eXgE\bhB
	 * t@CpX擾ł邱ƂmFB
	 */
	@Test
	public void testGetFilepath() {
		target.setFilepath("c:\test.csv");
		Assert.assertEquals("c:\test.csv",target.getFilepath());
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#setFilepath(String)} ̂߂̃eXgE\bhB
	 * t@CpXݒł邱ƂmFB
	 */
	@Test
	public void testSetFilepath() {
		target.setFilepath("c:\test.csv");
		Assert.assertEquals("c:\test.csv",target.getFilepath());
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#getAppend()} ̂߂̃eXgE\bhB
	 * t@CI[v[h擾ł邱ƂmFB
	 */
	@Test
	public void testGetAppend() {
		target.setAppend("true");
		Assert.assertEquals("true",target.getAppend());
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#setAppend(String)} ̂߂̃eXgE\bhB
	 * t@CI[v[hݒł邱ƂmFB
	 */
	@Test
	public void testSetAppend() {
		target.setAppend("true");
		Assert.assertEquals("true",target.getAppend());
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#getFieldList()} ̂߂̃eXgE\bhB
	 * tB[h񃊃Xg擾ł邱ƂmFB
	 */
	@Test
	public void testGetFieldList() {
		// ʃf[^
		DelimitedLineRecordFieldConfig field = new DelimitedLineRecordFieldConfig();
		field.setAlign("left");
		target.addField(field);
		field.setName("name");
		target.addField(field);
		field.setPadding(" ");
		target.addField(field);
		field.setPattern("0");
		target.addField(field);
		field.setPatternClass("pattern_class");
		target.addField(field);
		field.setLength("10");
		target.addField(field);
		field.setType("type");
		target.addField(field);

		Assert.assertEquals(7, target.getFieldList().size());
		Assert.assertEquals("left", target.getFieldList().get(0).getAlign());
		Assert.assertEquals("name", target.getFieldList().get(1).getName());
		Assert.assertEquals(" ", target.getFieldList().get(2).getPadding());
		Assert.assertEquals("0", target.getFieldList().get(3).getPattern());
		Assert.assertEquals("pattern_class", target.getFieldList().get(4).getPatternClass());
		Assert.assertEquals("10", target.getFieldList().get(5).getLength());
		Assert.assertEquals("type", target.getFieldList().get(6).getType());

	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#addField(DelimitedLineRecordFieldConfig)} ̂߂̃eXgE\bhB
	 * tB[h񃊃Xgɒǉ邱ƂmFB
	 *
	 */
	@Test
	public void testAddField() {
		// ʃf[^
		DelimitedLineRecordFieldConfig field = new DelimitedLineRecordFieldConfig();
		field.setAlign("left");
		target.addField(field);
		field.setName("name");
		target.addField(field);
		field.setPadding(" ");
		target.addField(field);
		field.setPattern("0");
		target.addField(field);
		field.setPatternClass("pattern_class");
		target.addField(field);
		field.setLength("10");
		target.addField(field);
		field.setType("type");
		target.addField(field);

		Assert.assertEquals(7, target.getFieldList().size());
		Assert.assertEquals("left", target.getFieldList().get(0).getAlign());
		Assert.assertEquals("name", target.getFieldList().get(1).getName());
		Assert.assertEquals(" ", target.getFieldList().get(2).getPadding());
		Assert.assertEquals("0", target.getFieldList().get(3).getPattern());
		Assert.assertEquals("pattern_class", target.getFieldList().get(4).getPatternClass());
		Assert.assertEquals("10", target.getFieldList().get(5).getLength());
		Assert.assertEquals("type", target.getFieldList().get(6).getType());

	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#getSeparator()} ̂߂̃eXgE\bhB
	 * Zp[^擾ł邱ƂmFB
	 */
	@Test
	public void testGetSeparator() {
		target.setSeparator(",");
		Assert.assertEquals(",",target.getSeparator());
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#setSeparator(String)} ̂߂̃eXgE\bhB
	 * Zp[^ݒł邱ƂmFB
	 */
	@Test
	public void testSetSeparator() {
		target.setSeparator(",");
		Assert.assertEquals(",",target.getSeparator());
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#getQuotechar()} ̂߂̃eXgE\bhB
	 * NH[g擾ł邱ƂmFB
	 */
	@Test
	public void testGetQuotechar() {
		target.setQuotechar("\"");
		Assert.assertEquals("\"",target.getQuotechar());
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#setQuotechar(String)} ̂߂̃eXgE\bhB
	 * NH[gݒł邱ƂmFB
	 */
	@Test
	public void testSetQuotechar() {
		target.setQuotechar("\"");
		Assert.assertEquals("\"",target.getQuotechar());
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#getEncode()} ̂߂̃eXgE\bhB
	 * GR[h擾ł邱ƂmFB
	 */
	@Test
	public void testGetEncode() {
		target.setEncode("Shift_JIS");
		Assert.assertEquals("Shift_JIS",target.getEncode());
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#setEncode(String)} ̂߂̃eXgE\bhB
	 * GR[hݒł邱ƂmFB
	 */
	@Test
	public void testSetEncode() {
		target.setEncode("Shift_JIS");
		Assert.assertEquals("Shift_JIS",target.getEncode());
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#getLineSeparator()} ̂߂̃eXgE\bhB
	 * sR[h擾ł邱ƂmFB
	 */
	@Test
	public void testGetLineSeparator() {
		target.setLineSeparator("\r\n");
		Assert.assertEquals("\r\n",target.getLineSeparator());
	}

	/**
	 * {@link DelimitedLineRecordWriterConfig#setLineSeparator(String)} ̂߂̃eXgE\bhB
	 * sR[hݒł邱ƂmFB
	 */
	@Test
	public void testSetLineSeparator() {
		target.setLineSeparator("\r\n");
		Assert.assertEquals("\r\n",target.getLineSeparator());
	}

}
