/*
 * FixedLengthRecordWriterConfigTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.fixed;

import jp.co.cybec.cb3.accessor.fileaccess.flat.fixed.FixedLengthRecordFieldConfig;
import jp.co.cybec.cb3.accessor.fileaccess.flat.fixed.FixedLengthRecordWriterConfig;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link FixedLengthRecordWriterConfig} ̃eXgP[XB
 * @author Sufang Gou
 */

public class FixedLengthRecordWriterConfigTest {
	FixedLengthRecordWriterConfig writerConfig = null;
	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		writerConfig = new FixedLengthRecordWriterConfig();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * {@link FixedLengthRecordWriterConfig#getFilepath()} ̂߂̃eXgE\bhB
	 * t@CpX擾ł邱ƂmFB
	 */
	@Test
	public void testGetFilepath() {
		writerConfig.setFilepath("c:\test.csv");
		Assert.assertEquals("c:\test.csv",writerConfig.getFilepath());
	}

	/**
	 * {@link FixedLengthRecordWriterConfig#setFilepath(String)} ̂߂̃eXgE\bhB
	 * t@CpXݒł邱ƂmFB
	 */
	@Test
	public void testSetFilepath() {
		writerConfig.setFilepath("c:\test.csv");
		Assert.assertEquals("c:\test.csv",writerConfig.getFilepath());
	}

	/**
	 * {@link FixedLengthRecordWriterConfig#getAppend()} ̂߂̃eXgE\bhB
	 * t@CI[v[h擾ł邱ƂmFB
	 */
	@Test
	public void testGetAppend() {
		writerConfig.setAppend("true");
		Assert.assertEquals("true",writerConfig.getAppend());
	}

	/**
	 * {@link FixedLengthRecordWriterConfig#setAppend(String)} ̂߂̃eXgE\bhB
	 * t@CI[v[h擾ł邱ƂmFB
	 */
	@Test
	public void testSetAppend() {
		writerConfig.setAppend("true");
		Assert.assertEquals("true",writerConfig.getAppend());
	}

	/**
	 * {@link FixedLengthRecordWriterConfig#getFieldList()} ̂߂̃eXgE\bhB
	 * tB[h񃊃Xg擾ł邱ƂmFB
	 */
	@Test
	public void testGetFieldList() {
		FixedLengthRecordFieldConfig field = new FixedLengthRecordFieldConfig();
		field.setAlign("left");
		writerConfig.addField(field);
		field.setName("name");
		writerConfig.addField(field);
		field.setPadding(" ");
		writerConfig.addField(field);
		field.setPattern("0");
		writerConfig.addField(field);
		field.setPatternClass("pattern_class");
		writerConfig.addField(field);
		field.setLength("10");
		writerConfig.addField(field);
		field.setType("type");
		writerConfig.addField(field);
		Assert.assertEquals(7, writerConfig.getFieldList().size());
		Assert.assertEquals("left", writerConfig.getFieldList().get(0).getAlign());
		Assert.assertEquals("name", writerConfig.getFieldList().get(1).getName());
		Assert.assertEquals(" ", writerConfig.getFieldList().get(2).getPadding());
		Assert.assertEquals("0", writerConfig.getFieldList().get(3).getPattern());
		Assert.assertEquals("pattern_class", writerConfig.getFieldList().get(4).getPatternClass());
		Assert.assertEquals("10", writerConfig.getFieldList().get(5).getLength());
		Assert.assertEquals("type", writerConfig.getFieldList().get(6).getType());

	}

	/**
	 * {@link FixedLengthRecordWriterConfig#addField(FixedLengthRecordFieldConfig)} ̂߂̃eXgE\bhB
	 * tB[h񃊃Xgݒł邱ƂmFB
	 */
	@Test
	public void testAddField() {
		FixedLengthRecordFieldConfig field = new FixedLengthRecordFieldConfig();
		field.setAlign("left");
		writerConfig.addField(field);
		field.setName("name");
		writerConfig.addField(field);
		field.setPadding(" ");
		writerConfig.addField(field);
		field.setPattern("0");
		writerConfig.addField(field);
		field.setPatternClass("pattern_class");
		writerConfig.addField(field);
		field.setLength("10");
		writerConfig.addField(field);
		field.setType("type");
		writerConfig.addField(field);
		Assert.assertEquals(7, writerConfig.getFieldList().size());
		Assert.assertEquals("left", writerConfig.getFieldList().get(0).getAlign());
		Assert.assertEquals("name", writerConfig.getFieldList().get(1).getName());
		Assert.assertEquals(" ", writerConfig.getFieldList().get(2).getPadding());
		Assert.assertEquals("0", writerConfig.getFieldList().get(3).getPattern());
		Assert.assertEquals("pattern_class", writerConfig.getFieldList().get(4).getPatternClass());
		Assert.assertEquals("10", writerConfig.getFieldList().get(5).getLength());
		Assert.assertEquals("type", writerConfig.getFieldList().get(6).getType());

	}

	/**
	 * {@link FixedLengthRecordWriterConfig#getEncode()} ̂߂̃eXgE\bhB
	 * R[h擾ł邱ƂmFB
	 */
	@Test
	public void testGetEncode() {
		writerConfig.setEncode("Shift_JIS");
		Assert.assertEquals("Shift_JIS",writerConfig.getEncode());
	}

	/**
	 * {@link FixedLengthRecordWriterConfig#setEncode(String)} ̂߂̃eXgE\bhB
	 * R[hݒł邱ƂmFB
	 */
	@Test
	public void testSetEncode() {
		writerConfig.setEncode("Shift_JIS");
		Assert.assertEquals("Shift_JIS",writerConfig.getEncode());
	}

	/**
	 * {@link FixedLengthRecordWriterConfig#getLineSeparator()} ̂߂̃eXgE\bhB
	 * sR[h擾ł邱ƂmFB
	 */
	@Test
	public void testGetLineSeparator() {
		writerConfig.setLineSeparator("\r\n");
		Assert.assertEquals("\r\n",writerConfig.getLineSeparator());
	}

	/**
	 * {@link FixedLengthRecordWriterConfig#setLineSeparator(String)} ̂߂̃eXgE\bhB
	 * sR[h擾ł邱ƂmFB
	 */
	@Test
	public void testSetLineSeparator() {
		writerConfig.setLineSeparator("\r\n");
		Assert.assertEquals("\r\n",writerConfig.getLineSeparator());
	}

}
