/*
 * FixedLengthRecordWriterTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.fixed;

import java.util.LinkedHashMap;

import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.fixed.FixedLengthRecordWriter;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link FixedLengthRecordWriter} ̃eXgP[XB
 * @author Sufang Gou
 */

public class FixedLengthRecordWriterTest {
	// NXCX^X
	private FixedLengthRecordWriter target = null;
	private FlatFileRecord record;

	/** ݒt@C  */
	private static final String CONFIG_WRITER1 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/writer/writeConfig1.xml";
	private static final String CONFIG_WRITER2 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/writer/writeConfig2.xml";

	/** ݒf[^t@C̋LqȂ */
	private static final String CONFIG_WRITER_PARSE_ERROR1 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/writer/writeConfig3.xml";
	private static final String CONFIG_WRITER_PARSE_ERROR2 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/writer/writeConfig4.xml";
	private static final String CONFIG_WRITER_PARSE_ERROR3 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/writer/writeConfig5.xml";

	/** f[^t@C */
	private static final String FILE_NORMAL= "src/test/testdata/fixed/test_write.txt";

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		// NXCX^X
		target = new FixedLengthRecordWriter();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * {@link FixedLengthRecordWriter#open(String)} ̂߂̃eXgE\bhB
	 * OȂƂmFB
	 */
	@Test
	public void testOpenString() {
		target.initialize(CONFIG_WRITER1);
		target.open(FILE_NORMAL);
	}

	/**
	 * {@link FixedLengthRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * OȂƂmF
	 * append true
	 * encode Shift_JIS
	 * lineSeparator \r\n
	 */
	@Test
	public void testWrite01() {
		// eXgf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();

		fileRecordMap.put("intField", "1111111111");
		fileRecordMap.put("strField1", "2222222222");
		fileRecordMap.put("strField2", "|@\"T̐ToPQRp");
		fileRecordMap.put("strField3", "www.bb@hotmail.com.cn");
		fileRecordMap.put("strField4", "10%");
		fileRecordMap.put("dateField1", "2007/05/28 00:00:00");
		fileRecordMap.put("dateField2", "2001/11/05 00:00:00");
		fileRecordMap.put("dateField3", "2001/10/05 08:01:00");
		fileRecordMap.put("dateField4", "2001/09/29 00:00:00");
		fileRecordMap.put("dateField5", "2001/09/10 10:10:010");
		fileRecordMap.put("longField", "123456789120325");
		fileRecordMap.put("shortField", "1045852642");
		fileRecordMap.put("bigField1", "1897512535544585264.2");
		fileRecordMap.put("bigField2", "18975125355445852642");
		fileRecordMap.put("floatField", "5125355445852642.2");

		// ݒt@CǂݍށB
		target.initialize(CONFIG_WRITER1);

		//t@CI[vB
		target.open();

		// FlatFileRecordf[^쐬B
		record = target.createFlatFileRecord(fileRecordMap);

		// R[h̏݁B
		target.write(record);
		target.write(record);
		target.write(record);

		// t@CN[YB
		target.close();
	}
	/**
	 * {@link FixedLengthRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * OȂƂmF
	 * append false
	 * encode null
	 * lineSeparator null
	 */
	@Test
	public void testWrite02() {
		// eXgf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();

		fileRecordMap.put("intField", "1111111111");
		fileRecordMap.put("strField1", "2222222222");
		fileRecordMap.put("strField2", "|@\"T̐ToPQRp");
		fileRecordMap.put("strField3", "www.bb@hotmail.com.cn");
		fileRecordMap.put("strField4", "10%");
		fileRecordMap.put("dateField1", "2007/05/28 00:00:00");
		fileRecordMap.put("dateField2", "2001/11/05 00:00:00");
		fileRecordMap.put("dateField3", "2001/10/05 08:01:00");
		fileRecordMap.put("dateField4", "2001/09/29 00:00:00");
		fileRecordMap.put("dateField5", "2001/09/10 10:10:010");
		fileRecordMap.put("longField", "123456789120325");
		fileRecordMap.put("shortField", "1045852642");
		fileRecordMap.put("bigField1", "1897512535544585264.2");
		fileRecordMap.put("bigField2", "18975125355445852642");
		fileRecordMap.put("floatField", "5125355445852642.2");

		// ݒt@CǂݍށB
		target.initialize(CONFIG_WRITER2);

		//t@CI[vB
		target.open();

		// FlatFileRecordf[^쐬B
		record = target.createFlatFileRecord(fileRecordMap);

		// R[h̏݁B
		target.write(record);
		target.write(record);
		target.write(record);

		// t@CN[YB
		target.close();

	}

	/**
	 * {@link FixedLengthRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * t@CI[vȂƂɗO邱ƂmFB
	 */
	@Test(expected = AccessorNotOpenException.class)
	public void testWrite03() {
		// eXgf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();

		fileRecordMap.put("intField", "1111111111");
		fileRecordMap.put("strField1", "2222222222");
		fileRecordMap.put("strField3", "www.bb@hotmail.com.cn");
		fileRecordMap.put("strField4", "10%");
		fileRecordMap.put("dateField1", "2007/05/28 00:00:00");
		fileRecordMap.put("dateField2", "2001/11/05 00:00:00");
		fileRecordMap.put("dateField3", "2001/10/05 08:01:00");
		fileRecordMap.put("dateField4", "2001/09/29 00:00:00");
		fileRecordMap.put("dateField5", "2001/09/10 10:10:010");
		fileRecordMap.put("longField", "123456789120325");
		fileRecordMap.put("shortField", "1045852642");
		fileRecordMap.put("bigField1", "1897512535544585264.2");
		fileRecordMap.put("bigField2", "18975125355445852642");
		fileRecordMap.put("floatField", "5125355445852642.2");

		// ݒt@CǂݍށB
		target.initialize(CONFIG_WRITER2);

		// FlatFileRecordf[^쐬B
		record = target.createFlatFileRecord(fileRecordMap);

		// R[h̏݁B
		target.write(record);
		target.write(record);
		target.write(record);

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * [U[`NX̃CX^XsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testWrite04() {
		// eXgf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();

		fileRecordMap.put("intField", "1111111111");

		// ݒt@CǂݍށB
		target.initialize(CONFIG_WRITER_PARSE_ERROR1);

		//t@CI[vB
		target.open();

		// FlatFileRecordf[^쐬B
		record = target.createFlatFileRecord(fileRecordMap);

		// R[h̏݁B
		target.write(record);

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * Psf[^̃oCg <> ݒt@C̃oCgv̂ƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testWrite05() {
		// eXgf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();

		fileRecordMap.put("strField1", "");

		// ݒt@Cǂݍ
		target.initialize(CONFIG_WRITER_PARSE_ERROR2);

		//t@CI[vB
		target.open();

		// FlatFileRecordf[^쐬B
		record = target.createFlatFileRecord(fileRecordMap);

		// R[h̏݁B
		target.write(record);

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordWriter#createFlatFileRecord(Map)} ̂߂̃eXgE\bhB
	 * Mapnull̂ƂɗOȂƂmFB
	 */
	@Test
	public void testWrite06() {

		// FlatFileRecordf[^쐬܂B
		target.createFlatFileRecord(null);
	}

	/**
	 * {@link FixedLengthRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * f[^t@C̃tH[}bgs̏ꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testWrite07() {
		// eXgf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();

		fileRecordMap.put("intField", "1111111111");

		// ݒt@Cǂݍ
		target.initialize(CONFIG_WRITER_PARSE_ERROR3);

		//t@CI[vB
		target.open();

		// FlatFileRecordf[^쐬B
		record = target.createFlatFileRecord(fileRecordMap);

		// R[h̏݁B
		target.write(record);

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * f[^t@Cnull̏ꍇAOȂƂmFB
	 */
	@Test
	public void testWrite08() {
		// ݒt@Cǂݍ
		target.initialize(CONFIG_WRITER_PARSE_ERROR3);

		//t@CI[vB
		target.open();

		// R[h̏݁B
		target.write(null);

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordWriter#initialize(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testInitialize() {
		// ݒt@CǂݍށB
		target.initialize(CONFIG_WRITER1);
	}

	/**
	 * {@link FixedLengthRecordWriter#initialize(String)} ̂߂̃eXgE\bhB<br>
	 * ɑ݂ȂL[iݒt@Cjw肵ƂɗO邱ƂmFB
	 */
	@Test(expected = ConfigFileNotFoundException.class)
	public void testInitializeConfigFileNotFoundException() {
		// ݒt@CǂݍށB
		target.initialize("aaa");
	}

	/**
	 * {@link FixedLengthRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * R[hkey啶̏ꍇAOȂƂmF
	 * append true
	 * encode Shift_JIS
	 * lineSeparator \r\n
	 */
	@Test
	public void testWriteFiledNameLower() {
		// eXgf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();

		fileRecordMap.put("INTFIELD", "2222222222");
		fileRecordMap.put("STRFIELD1", "2222222222");
		fileRecordMap.put("STRFIELD2", "|@\"T̐ToPQRp");
		fileRecordMap.put("STRFIELD3", "www.bb@hotmail.com.cn");
		fileRecordMap.put("STRFIELD4", "10%");
		fileRecordMap.put("DATEFIELD1", "2007/05/28 00:00:00");
		fileRecordMap.put("DATEFIELD2", "2001/11/05 00:00:00");
		fileRecordMap.put("DATEFIELD3", "2001/10/05 08:01:00");
		fileRecordMap.put("DATEFIELD4", "2001/09/29 00:00:00");
		fileRecordMap.put("DATEFIELD5", "2001/09/10 10:10:010");
		fileRecordMap.put("LONGFIELD", "123456789120325");
		fileRecordMap.put("SHORTFIELD", "1045852642");
		fileRecordMap.put("BIGFIELD1", "1897512535544585264.2");
		fileRecordMap.put("BIGFIELD2", "18975125355445852642");
		fileRecordMap.put("FLOATFIELD", "5125355445852642.2");

		// ݒt@CǂݍށB
		target.initialize(CONFIG_WRITER1);

		//t@CI[vB
		target.open();

		// FlatFileRecordf[^쐬B
		record = target.createFlatFileRecord(fileRecordMap);

		// R[h̏݁B
		target.write(record);
		target.write(record);
		target.write(record);

		// t@CN[YB
		target.close();
	}
}
