/*
 * XMLElementTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;

import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLAttribute;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLAttributes;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLElement;
import jp.co.cybec.cb3.exception.DataFormatException;
import junit.framework.Assert;

import org.junit.Test;

/**
 * {@link XMLElement} ̃eXgP[XB
 * @author Daisuke Suga
 */
public class XMLElementTest {

	XMLElement target = null;

	/**
	 * {@link XMLElement#XMLElement(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testXMLElementString() {
		target = new XMLElement("test1");
	}

	/**
	 * {@link XMLElement#XMLElement(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testXMLElementStringStringString() {
		target = new XMLElement("test1", "key", "path");
	}

	/**
	 * {@link XMLElement#getName()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetName() {
		String expected1 = "test1";
		String expected2 = "test2";

		target = new XMLElement(expected1);
		Assert.assertEquals(expected1, target.getName());

		target = new XMLElement(expected2, "aaa2", "bbb2");
		Assert.assertEquals(expected2, target.getName());
	}

	/**
	 * {@link XMLElement#getString()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetString() {
		String expected = "aaa1";
		target = new XMLElement("test1");
		target.setString(expected);
		Assert.assertEquals(expected, target.getString());
	}

	/**
	 * {@link XMLElement#setString(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetString() {
		target = new XMLElement("test1");
		target.setString("aaa1");
	}

	/**
	 * {@link XMLElement#getInteger()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetInteger() {
		Integer expected = new Integer("10");
		target = new XMLElement("test1");
		target.setInteger(expected);
		Assert.assertEquals(expected, target.getInteger());
	}

	/**
	 * {@link XMLElement#getInteger()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetIntegerDataFormatException() {
		target = new XMLElement("test1");
		target.setString("aaa1");
		target.getInteger();
	}

	/**
	 * {@link XMLElement#getInteger()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetIntegerDataFormatException2() {
		target = new XMLElement("test1", "key", "path");
		target.setString("aaa1");
		target.getInteger();
	}

	/**
	 * {@link XMLElement#setInteger(Integer)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetInteger() {
		target = new XMLElement("test1");
		target.setInteger(new Integer("10"));
	}

	/**
	 * {@link XMLElement#getLong()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetLong() {
		Long expected = new Long("10");
		target = new XMLElement("test1");
		target.setLong(expected);
		Assert.assertEquals(expected, target.getLong());
	}

	/**
	 * {@link XMLElement#getLong()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetLongDataFormatException() {
		target = new XMLElement("test1");
		target.setString("aaa1");
		target.getLong();
	}

	/**
	 * {@link XMLElement#getLong()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetLongDataFormatException2() {
		target = new XMLElement("test1", "key", "path");
		target.setString("aaa1");
		target.getLong();
	}

	/**
	 * {@link XMLElement#setLong(Long)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetLong() {
		target = new XMLElement("test1");
		target.setLong(new Long("10"));
	}

	/**
	 * {@link XMLElement#getFloat()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetFloat() {
		Float expected = new Float("1.1");
		target = new XMLElement("test1");
		target.setFloat(expected);
		Assert.assertEquals(expected, target.getFloat());
	}

	/**
	 * {@link XMLElement#getFloat()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetFloatDataFormatException() {
		target = new XMLElement("test1");
		target.setString("aaa1");
		target.getFloat();
	}

	/**
	 * {@link XMLElement#getFloat()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetFloatDataFormatException2() {
		target = new XMLElement("test1", "key", "path");
		target.setString("aaa1");
		target.getFloat();
	}

	/**
	 * {@link XMLElement#setFloat(Float)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetFloat() {
		target = new XMLElement("test1");
		target.setFloat(new Float("1.1"));
	}

	/**
	 * {@link XMLElement#getShort()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetShort() {
		Short expected = new Short("10");
		target = new XMLElement("test1");
		target.setShort(expected);
		Assert.assertEquals(expected, target.getShort());
	}

	/**
	 * {@link XMLElement#getShort()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetShortDataFormatException() {
		target = new XMLElement("test1");
		target.setString("aaa1");
		target.getShort();
	}

	/**
	 * {@link XMLElement#getShort()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetShortDataFormatException2() {
		target = new XMLElement("test1", "key", "path");
		target.setString("aaa1");
		target.getShort();
	}

	/**
	 * {@link XMLElement#setShort(Short)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetShort() {
		target = new XMLElement("test1");
		target.setShort(new Short("10"));
	}

	/**
	 * {@link XMLElement#getBigDecimal()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetBigDecimal() {
		BigDecimal expected = new BigDecimal("10");
		target = new XMLElement("test1");
		target.setBigDecimal(expected);
		Assert.assertEquals(expected, target.getBigDecimal());
	}

	/**
	 * {@link XMLElement#getBigDecimal()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetBigDecimalDataFormatException() {
		target = new XMLElement("test1");
		target.setString("aaa1");
		target.getBigDecimal();
	}

	/**
	 * {@link XMLElement#getBigDecimal()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetBigDecimalDataFormatException2() {
		target = new XMLElement("test1", "key", "path");
		target.setString("aaa1");
		target.getBigDecimal();
	}

	/**
	 * {@link XMLElement#setBigDecimal(BigDecimal)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetBigDecimal() {
		target = new XMLElement("test1");
		target.setBigDecimal(new BigDecimal("10"));
	}

	/**
	 * {@link XMLElement#getDate()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetDate() throws Exception {
		Date expected = DateFormat.getDateInstance().parse("2008/07/03");
		target = new XMLElement("test1");
		target.setDate(expected);
		Assert.assertEquals(expected, target.getDate());
	}

	/**
	 * {@link XMLElement#getDate()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetDateDataFormatException() {
		target = new XMLElement("test1");
		target.setString("aaa1");
		target.getDate();
	}

	/**
	 * {@link XMLElement#getDate()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetDateDataFormatException2() {
		target = new XMLElement("test1", "key", "path");
		target.setString("aaa1");
		target.getDate();
	}

	/**
	 * {@link XMLElement#setDate(Date)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetDate() throws Exception {
		target = new XMLElement("test1");
		target.setDate(DateFormat.getDateInstance().parse("2008/07/03"));
	}

	/**
	 * {@link XMLElement#getURI()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetURI() {
		String expected = "aaa1";
		target = new XMLElement("test1");
		target.setURI(expected);
		Assert.assertEquals(expected, target.getURI());
	}

	/**
	 * {@link XMLElement#setURI(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetURI() {
		target = new XMLElement("test1");
		target.setURI("aaa1");
	}

	/**
	 * {@link XMLElement#getQName()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetQName() {
		String expected = "aaa1";
		target = new XMLElement("test1");
		target.setQName(expected);
		Assert.assertEquals(expected, target.getQName());
	}

	/**
	 * {@link XMLElement#setQName(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetQName() {
		target = new XMLElement("test1");
		target.setQName("aaa1");
	}

	/**
	 * {@link XMLElement#getAttributes()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetAttributes() {
		XMLAttributes expected = new XMLAttributes();
		XMLAttribute attribute1 = new XMLAttribute("test1", "aaa1");
		XMLAttribute attribute2 = new XMLAttribute("test2", "aaa2");
		expected.putAttribute(attribute1);
		expected.putAttribute(attribute2);

		target = new XMLElement("test1");
		target.setAttributes(expected);
		Assert.assertEquals(expected, target.getAttributes());
	}

	/**
	 * {@link XMLElement#setAttributes(XMLAttributes)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetAttributes() {
		target = new XMLElement("test1");
		target.setAttributes(new XMLAttributes());
	}

	/**
	 * {@link XMLElement#putAttribute(XMLAttribute)} ̂߂̃eXgE\bhB<br>
	 * ǉ{@link XMLAttribute}擾ł邱ƂmFB
	 */
	@Test
	public void testPutAttribute() {
		String key1 = "test1";
		String key2 = "test2";
		XMLAttribute expected1 = new XMLAttribute(key1, "aaa1");
		XMLAttribute expected2 = new XMLAttribute(key2, "aaa2");

		target = new XMLElement("test1");
		target.putAttribute(expected1);
		target.putAttribute(expected2);
		Assert.assertEquals(expected1, target.getAttributes().getAttribute(key1));
		Assert.assertEquals(expected2, target.getAttributes().getAttribute(key2));
	}

	/**
	 * {@link XMLElement#getAttributes()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testToString() {
		String expected = "aaa1";
		target = new XMLElement("test1");
		target.setString(expected);
		Assert.assertEquals(expected, target.toString());
	}

}
