/*
 * XMLPathTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;

import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLPath;
import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.BadXmlGrammerException;
import junit.framework.Assert;

import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link XMLPath} ̃eXgP[XB
 * @author Daisuke Suga
 */
public class XMLPathTest {

	XMLPath target = null;
	BufferedInputStream stream = null;
	XmlObject xml = null;

	/** ǂݍݗp t@C */
	private static final String FILE_READER1 = "./src/test/testdata/xml/reader1.xml";

	@Before
	public void setUp() throws Exception {
		File file = new File(FILE_READER1);
		stream = new BufferedInputStream(new FileInputStream(file));
		xml = XmlObject.Factory.parse(stream);
	}

	@After
	public void tearDown() throws Exception {
		if (stream != null) {
			stream.close();
			stream = null;
		}
	}

	/**
	 * {@link XMLPath#XMLPath()} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testXMLPath() {
		target = new XMLPath();
		Assert.assertNotNull(target);
	}

	/**
	 * {@link XMLPath#XMLPath(String, org.apache.xmlbeans.XmlObject, String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testXMLPathStringXmlObjectString() throws Exception {
		target = new XMLPath("test1", xml, "*/dept");
		Assert.assertNotNull(target);
	}

	/**
	 * {@link XMLPath#XMLPath(String, org.apache.xmlbeans.XmlObject, String)} ̂߂̃eXgE\bhB<br>
	 * J[\̍쐬ɎsƂɗO邱ƂmFB
	 */
	@Test(expected = AccessorUnknownException.class)
	public void testXMLPathStringXmlObjectStringAccessorUnknownException() {
		target = new XMLPath("test1", (XmlObject) null, "*/dept");
	}

	/**
	 * {@link XMLPath#XMLPath(String, org.apache.xmlbeans.XmlObject, String)} ̂߂̃eXgE\bhB<br>
	 * ̌pXȂƂɗO邱ƂmFB
	 */
	@Test(expected = BadXmlGrammerException.class)
	public void testXMLPathStringXmlObjectStringBadXmlGrammerException() throws Exception {
		target = new XMLPath("test1", xml, null);
		stream.close();
	}

	/**
	 * {@link XMLPath#XMLPath(String, org.apache.xmlbeans.XmlCursor, String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testXMLPathStringXmlCursorString() throws Exception {
		target = new XMLPath("test1", xml.newCursor(), "*/dept");
		Assert.assertNotNull(target);
	}

	/**
	 * {@link XMLPath#next()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testNext() {
		target = new XMLPath("test1", xml, "*/dept/employee-list/employee/name");
		Assert.assertNotNull(target);
		Assert.assertEquals("test10", target.next().toString());
		Assert.assertEquals("test11", target.next().toString());
		Assert.assertEquals("test20", target.next().toString());
		Assert.assertEquals("test21", target.next().toString());
		Assert.assertNull(target.next());
	}

	/**
	 * {@link XMLPath#next()} ̂߂̃eXgE\bhB<br>
	 * XmlObjectNULL̂ƂɗO邱ƂmFB
	 */
	@Test(expected = AccessorUnknownException.class)
	public void testNextAccessorUnknownException() {
		target = new XMLPath("test1", (XmlCursor) null, "*/dept/employee-list/employee/name");
		target.next();
	}

	/**
	 * {@link XMLPath#selectChildPath(String)} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testSelectChildPath() {
		XMLPath parent = new XMLPath("test1", xml, "*/dept");
		Assert.assertNotNull(parent);
		Assert.assertNotNull(parent.next());
		target = parent.selectChildPath("./employee-list/employee/name");
		Assert.assertEquals("test10", target.next().toString());
		Assert.assertEquals("test11", target.next().toString());
		Assert.assertNull(target.next());
		Assert.assertNotNull(parent.next());
		target = parent.selectChildPath("./employee-list/employee/name");
		Assert.assertEquals("test20", target.next().toString());
		Assert.assertEquals("test21", target.next().toString());
		Assert.assertNull(target.next());
		Assert.assertNull(parent.next());
	}

	/**
	 * {@link XMLPath#selectChildPath(String)} ̂߂̃eXgE\bhB<br>
	 * XmlCursorNULL̂ƂɗO邱ƂmFB
	 */
	@Test(expected = AccessorUnknownException.class)
	public void testSelectChildPathAccessorUnknownException() {
		target = new XMLPath("test1", (XmlCursor) null, "*/dept");
		target.selectChildPath("./employee-list/employee/name");
	}

	/**
	 * {@link XMLPath#selectChildPath(String)} ̂߂̃eXgE\bhB<br>
	 * ̌pXȂƂɗO邱ƂmFB
	 */
	@Test(expected = BadXmlGrammerException.class)
	public void testSelectChildPathBadXmlGrammerException() {
		target = new XMLPath("test1", xml.newCursor(), "*/dept");
		target.selectChildPath("");
	}

}
