/*
 * CB3ServiceTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.container.service;

import java.util.HashMap;

import jp.co.cybec.cb3.accessor.Accessor;
import jp.co.cybec.cb3.accessor.DataAccessContext;
import jp.co.cybec.cb3.container.service.CB3Service;
import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.ServiceException;
import jp.co.cybec.cb3.exception.ServiceExecutionException;
import jp.co.cybec.cb3.exception.ServiceRuntimeException;
import jp.co.cybec.cb3.mock.accessor.MockDataAccessContext;
import jp.co.cybec.cb3.mock.accessor.MockDataAccessContextThrowException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;
import junit.framework.Assert;

import org.junit.Test;


/**
 * CB3ServicẽeXgP[XB
 * @author Naoko Sugimoto
 */
public class CB3ServiceTest {

	/**
	 * {@link jp.co.cybec.cb3.container.service.CB3Service#setDataAccessContext(jp.co.cybec.cb3.accessor.DataAccessContext)} ̂߂̃eXgE\bhB
	 * setDataAccessContext()ɂf[^ANZXReLXgZbgA
	 * getDataAccessContext()ɂf[^ANZXReLXg擾ł邱ƂmFB
	 */
	@Test
	public void testSetDataAccessContext() {

		// T[rX𐶐B
		CB3Service cB3Service = new CB3Service() {
			protected int doService(ServiceParameters serviceParameters, RuntimeParameters runtimeParameters) {
				return 0;
			}
		};

		// f[^ANZXReLXgZbgB
		MockDataAccessContext dataAccessContext = new MockDataAccessContext(new HashMap<String, Accessor>());
		cB3Service.setDataAccessContext(dataAccessContext);
		// f[^ANZXReLXg擾B
		Assert.assertEquals(dataAccessContext, cB3Service.getDataAccessContext());
	}

	/**
	 * {@link jp.co.cybec.cb3.container.service.CB3Service#callService(jp.co.cybec.cb3.session.ServiceParameters, jp.co.cybec.cb3.session.RuntimeParameters)} ̂߂̃eXgE\bhB
	 * \bhsA߂lmFB
	 */
	@Test
	public void testCallService() {

		// T[rX𐶐B
		CB3Service cB3Service = new CB3Service() {
			protected int doService(ServiceParameters serviceParameters, RuntimeParameters runtimeParameters) {
				return 0;
			}
		};

		// f[^ANZXReLXgZbgB
		MockDataAccessContext dataAccessContext = new MockDataAccessContext(new HashMap<String, Accessor>());
		cB3Service.setDataAccessContext(dataAccessContext);

		// T[rXsB
		int returnCode = cB3Service.callService(new ServiceParameters(), new RuntimeParameters(null));

		// ߂l`FbNB
		Assert.assertEquals(0, returnCode);

		// f[^ANZXReLXg̃[XĂ΂Ă邱ƂmFB
		Assert.assertTrue(dataAccessContext.isReleased());
	}

	/**
	 * {@link jp.co.cybec.cb3.container.service.CB3Service#callService(jp.co.cybec.cb3.session.ServiceParameters, jp.co.cybec.cb3.session.RuntimeParameters)} ̂߂̃eXgE\bhB
	 * rWlXWbNŗOƂA{@link ServiceRuntimeException}ɒu
	 * 邱ƂmFB
	 */
	@Test
	public void testCallServiceCatchException() {

		// T[rX𐶐B
		CB3Service cB3Service = new CB3Service() {
			protected int doService(ServiceParameters serviceParameters, RuntimeParameters runtimeParameters) throws ServiceException {
				throw new ServiceException("ÕeXgłB");
			}
		};
		// f[^ANZXReLXgZbgB
		MockDataAccessContext dataAccessContext = new MockDataAccessContext(new HashMap<String, Accessor>());
		cB3Service.setDataAccessContext(dataAccessContext);

		// T[rXsB
		try {
			cB3Service.callService(new ServiceParameters(), new RuntimeParameters(null));
			Assert.fail();
		} catch (ServiceExecutionException e) {
			System.out.println(e.getCause());
			if (e.getCause() instanceof ServiceException) {
				// zǂ
			} else {
				Assert.fail();
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.container.service.CB3Service#callService(jp.co.cybec.cb3.session.ServiceParameters, jp.co.cybec.cb3.session.RuntimeParameters)} ̂߂̃eXgE\bhB
	 * ANZbT̃[XŗOƂA{@link ServiceRuntimeException}ɒu
	 * 邱ƂmFB
	 */
	@Test
	public void testCallServiceCatchAccessorException() {

		// T[rX𐶐B
		CB3Service cB3Service = new CB3Service() {
			protected int doService(ServiceParameters serviceParameters, RuntimeParameters runtimeParameters) {
				return 0;
			}
		};

		// f[^ANZXReLXgZbgB
		DataAccessContext dataAccessContext = new MockDataAccessContextThrowException(new HashMap<String, Accessor>());
		cB3Service.setDataAccessContext(dataAccessContext);

		// T[rXsB
		try {
			cB3Service.callService(new ServiceParameters(), new RuntimeParameters(null));
			Assert.fail();
		} catch (ServiceExecutionException e) {
			if (e.getCause() instanceof AccessorUnknownException) {
				// zǂ
			} else {
				Assert.fail();
			}
		}
	}
}
