/*
 * AccessorRuntimeExceptionTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.exception;

import junit.framework.Assert;
import org.junit.Test;

/**
 * AccessorRuntimeExceptioñeXgP[XB
 * @author Naoko Sugimoto
 */
public class AccessorRuntimeExceptionTest {

	/**
	 * {@link jp.co.cybec.cb3.exception.AccessorRuntimeException#AccessorRuntimeException(java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);

		// AccessorRuntimeException𐶐B
		AccessorRuntimeException newException = new AccessorRuntimeException(causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(causeMessage));
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.AccessorRuntimeException#AccessorRuntimeException(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithString() {
		String message = "XXXXɎs܂B";

		// AccessorRuntimeException𐶐B
		AccessorRuntimeException newException = new AccessorRuntimeException(message);

		// bZ[WemFB
		Assert.assertEquals(message, newException.getMessage());
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.AccessorRuntimeException#AccessorRuntimeException(java.lang.String, java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithStringAndException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);
		// Vǉ郁bZ[WB
		String newMessage = "YYYY̏ɗO܂B";

		// AccessorRuntimeException𐶐B
		AccessorRuntimeException newException = new AccessorRuntimeException(newMessage, causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(newMessage));
	}

}
