/*
 * CB3RuntimeExceptionTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.exception;

import jp.co.cybec.cb3.exception.CB3RuntimeException;
import junit.framework.Assert;
import org.junit.Test;

/**
 * CB3RuntimeExceptioñeXgP[XB
 * @author Naoko Sugimoto
 */
public class CB3RuntimeExceptionTest {

	/**
	 * {@link jp.co.cybec.cb3.exception.CB3RuntimeException#CB3RuntimeException(java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);

		// CB3RuntimeException𐶐B
		CB3RuntimeException newException = new CB3RuntimeException(causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(causeMessage));
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.CB3RuntimeException#CB3RuntimeException(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithString() {
		String message = "XXXXɎs܂B";

		// CB3RuntimeException𐶐B
		CB3RuntimeException newException = new CB3RuntimeException(message);

		// bZ[WemFB
		Assert.assertEquals(message, newException.getMessage());
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.CB3RuntimeException#CB3RuntimeException(java.lang.String, java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithStringAndException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);
		// Vǉ郁bZ[WB
		String newMessage = "YYYY̏ɗO܂B";

		// CB3RuntimeException𐶐B
		CB3RuntimeException newException = new CB3RuntimeException(newMessage, causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(newMessage));
	}

}
