/*
 * MockServiceCheckPrameters.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.mock.container.service;

import jp.co.cybec.cb3.container.service.CB3Service;
import jp.co.cybec.cb3.exception.ServiceException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;

/**
 * T[rX̃bNB<br>
 * {@link ServiceParameters}́userviceParameter1v
 * {@link RuntimeParameters}́uruntimeParameter1vɒlݒ肳Ă邩`FbNA
 * lݒ肳ĂȂꍇ{@link ServiceException}X[܂B<br>
 * ܂A{@link ServiceParameters}́uexitCodevsʂƂĕԋp܂B
 * @author Naoko Sugimoto
 */
public class MockServiceCheckPrameters extends CB3Service {

	/**
	 * T[rXs郁\bhłB
	 * ̃bNł́AServiceExceptionX[܂B
	 * @param serviceParameters T[rXp[^
	 * @param runtimeParameters Np[^
	 * @return s
	 * @throws ServiceException Ɩŉ炩̗OꍇB
	 */
	@Override
	protected int doService(ServiceParameters serviceParameters, RuntimeParameters runtimeParameters)
			throws ServiceException {
		if (serviceParameters == null) {
			throw new ServiceException("ServiceParameters is null");
		}
		if (runtimeParameters == null) {
			throw new ServiceException("RuntimeParameters is null");
		}
		if (serviceParameters.get("serviceParameter1") == null) {
			throw new ServiceException("serviceParameter1 is null");
		}
		if (runtimeParameters.get("runtimeParameter1") == null) {
			throw new ServiceException("runtimeParameter1 is null");
		}
		Integer exitCode = (Integer) serviceParameters.get("exitCode");
		return exitCode;
	}

}
