/*
 * RuntimeArgumentsAnalyzerTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.session;


import jp.co.cybec.cb3.exception.RuntimeArgumentsAnalyzeException;
import jp.co.cybec.cb3.session.RuntimeArgumentsAnalyzer;
import jp.co.cybec.cb3.session.RuntimeParameters;
import junit.framework.Assert;

import org.junit.Test;

/**
 * RuntimeArgumentsAnalyzer̃eXgP[XB
 * @author Naoko Sugimoto
 */
public class RuntimeArgumentsAnalyzerTest {

	/**
	 * {@link jp.co.cybec.cb3.session.RuntimeArgumentsAnalyzer#RuntimeArgumentsAnalyzer(String[], String...)} ̂߂̃eXgE\bhB
	 * zǂ̈nꂽꍇ̃eXgB
	 */
	@Test
	public void testNomalParameters() {

		String[] argument = new String[]{
				"-ReserveKey1", "reserveValue1", "-ReserveKey2", "reserveValue2", "-AppParams", "key1=value1", "key2="
		};
		// RuntimeArgumentsAnalyzer𐶐B
		RuntimeArgumentsAnalyzer analyzer = new RuntimeArgumentsAnalyzer(argument, "-ReserveKey1", "-ReserveKey2");

		// Np[^i\񕪁j擾łĂ邱ƂmFB
		Assert.assertEquals("reserveValue1", analyzer.getReservedParameter("-ReserveKey1"));
		Assert.assertEquals("reserveValue2", analyzer.getReservedParameter("-ReserveKey2"));
		// Np[^iCӕj擾łĂ邱ƂmFB
		RuntimeParameters runtimeParameters = analyzer.getRuntimeParameters();
		Assert.assertEquals("value1", runtimeParameters.get("key1"));
		Assert.assertEquals("", runtimeParameters.get("key2"));
	}

	/**
	 * {@link jp.co.cybec.cb3.session.RuntimeArgumentsAnalyzer#RuntimeArgumentsAnalyzer(String[], String...)} ̂߂̃eXgE\bhB
	 * zǂ̈nꂽꍇ̃eXgB
	 * u-AppParamsvgpȂꍇB
	 */
	@Test
	public void testNomalParametersWithoutAppParam() {

		String[] argument = new String[]{
				"-key1", "value1", "-key2", "-123"
		};
		// RuntimeArgumentsAnalyzer𐶐B
		RuntimeArgumentsAnalyzer analyzer = new RuntimeArgumentsAnalyzer(argument, "-key1", "-key2");

		// \p[^擾łĂ邱ƂmFB
		Assert.assertEquals("value1", analyzer.getReservedParameter("-key1"));
		Assert.assertEquals("-123", analyzer.getReservedParameter("-key2"));
	}

	/**
	 * {@link jp.co.cybec.cb3.session.RuntimeArgumentsAnalyzer#RuntimeArgumentsAnalyzer(String[], String...)} ̂߂̃eXgE\bhB
	 * sȈnꂽꍇ̃eXgB
	 * lŵȂ\L[nꂽꍇAK؂ȗO邱ƂmFB
	 * ju-key1 -key2 value2v
	 *     u-key1 value1 -key2v
	 *     u-key1 value1 -key2 -AppParam parameter1v
	 */
	@Test
	public void testNoValueParameters() {
		String[] argument = new String[]{
				"-key1", "-key2", "value2"
		};
		try {
			// RuntimeArgumentsAnalyzer𐶐B
			new RuntimeArgumentsAnalyzer(argument, "-key1", "-key2");
			// OȂ΃eXgs
			Assert.fail();
		} catch (RuntimeArgumentsAnalyzeException e) {
			// zǂ
		}

		argument = new String[]{
				"-key1", "value1", "-key2"
		};
		try {
			// RuntimeArgumentsAnalyzer𐶐B
			new RuntimeArgumentsAnalyzer(argument, "-key1", "-key2");
			// OȂ΃eXgs
			Assert.fail();
		} catch (RuntimeArgumentsAnalyzeException e) {
			// zǂ
		}

		argument = new String[]{
				"-key1", "value1", "-key2", "-AppParam", "parameter1"
		};
		try {
			// RuntimeArgumentsAnalyzer𐶐B
			new RuntimeArgumentsAnalyzer(argument, "-key1", "-key2");
			// OȂ΃eXgs
			Assert.fail();
		} catch (RuntimeArgumentsAnalyzeException e) {
			// zǂ
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.session.RuntimeArgumentsAnalyzer#RuntimeArgumentsAnalyzer(String[], String...)} ̂߂̃eXgE\bhB
	 * sȈnꂽꍇ̃eXgB
	 * L[̂Ȃp[^lw肳ꂽꍇAK؂ȗO邱ƂmFB
	 * juvalue1 -key2 value2 v
	 *     u-key1 value1 value2v
	 */
	@Test(expected=RuntimeArgumentsAnalyzeException.class)
	public void testNoKeyParameters() {
		String[] argument = new String[]{
				"value1", "-key2", "value2"
		};
		try {
			// RuntimeArgumentsAnalyzer𐶐B
			new RuntimeArgumentsAnalyzer(argument, "-key1", "-key2");
			// OȂ΃eXgs
			Assert.fail();
		} catch (RuntimeArgumentsAnalyzeException e) {
			// zǂ
		}

		argument = new String[]{
				"-key1", "value1", "value2"
		};
		// RuntimeArgumentsAnalyzer𐶐B
		new RuntimeArgumentsAnalyzer(argument, "-key1", "-key2");
	}

	/**
	 * {@link jp.co.cybec.cb3.session.RuntimeArgumentsAnalyzer#RuntimeArgumentsAnalyzer(String[], String...)} ̂߂̃eXgE\bhB
	 * sȈnꂽꍇ̃eXgB
	 * dL[w肳ꂽꍇAK؂ȗO邱ƂmFB
	 * ju-key1 value1a -key2 value2 -key1 value1bv
	 */
	@Test(expected=RuntimeArgumentsAnalyzeException.class)
	public void testDuplicateKeyParameters() {
		String[] argument = new String[]{
				"-key1", "value1a", "-key2", "value2", "-key1", "value1b"
		};
		// RuntimeArgumentsAnalyzer𐶐B
		new RuntimeArgumentsAnalyzer(argument, "-key1", "-key2", "-key3");
	}


	/**
	 * {@link jp.co.cybec.cb3.session.RuntimeArgumentsAnalyzer#RuntimeArgumentsAnalyzer(String[], String...)} ̂߂̃eXgE\bhB
	 * u-AppParamsvɁukey1=value1v̌`ł͂Ȃnꂽꍇ̃eXgB
	 * "="܂܂Ȃw肳ꂽꍇAK؂ȗO邱ƂmFB
	 */
	@Test(expected=RuntimeArgumentsAnalyzeException.class)
	public void testBadAppParams() {

		String[] argument = new String[]{
				"-AppParams", "dummy"
		};
		// RuntimeArgumentsAnalyzer𐶐B
		new RuntimeArgumentsAnalyzer(argument);
	}

}
