/*
 * ApplicationExiterDelegaterTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util;

import jp.co.cybec.cb3.mock.util.MockApplicationExiter;
import jp.co.cybec.cb3.util.ApplicationExiterDelegater;
import junit.framework.Assert;

import org.junit.Test;

/**
 * ApplicationExiterDelegater̃eXgP[XB
 * @author Naoko Sugimoto
 */
public class ApplicationExiterDelegaterTest {

	/**
	 * {@link jp.co.cybec.cb3.util.ApplicationExiterDelegater#getInstance()} ̂߂̃eXgE\bhB
	 * VOgɂȂĂ邱ƂmFB
	 */
	@Test
	public void testApplicationExiterDelegater() {

		ApplicationExiterDelegater delegater1 = ApplicationExiterDelegater.getInstance();
		ApplicationExiterDelegater delegater2 = ApplicationExiterDelegater.getInstance();
		Assert.assertSame(delegater1, delegater2);
	}

	/**
	 * {@link jp.co.cybec.cb3.util.ApplicationExiterDelegater#exit(int)} ̂߂̃eXgE\bhB
	 * exit()sAʃR[hZbgłĂ邱ƂmFB
	 */
	@Test
	public void testExit() {

		ApplicationExiterDelegater delegater = ApplicationExiterDelegater.getInstance();
		/*
		 * ApplicationExiterƂMockApplicationExitergpB
		 * ftHgApplicationExiterImplł́AVXeIĂ܂eXgłȂ߁B
		 */
		delegater.setApplicationExiter(new MockApplicationExiter());
		// ʃR[hZbgB
		delegater.exit(0);
		// ZbgʃR[h擾ł邱ƂmFB
		Assert.assertEquals(0, delegater.getReturnCode());
		// ʃR[hZbgB
		delegater.exit(-9);
		// ZbgʃR[h擾ł邱ƂmFB
		Assert.assertEquals(-9, delegater.getReturnCode());
	}
}
