/*
 * CB3BeanFactoryTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util;

import javax.sql.DataSource;

import jp.co.cybec.cb3.util.CB3BeanFactory;
import junit.framework.Assert;

import org.junit.Test;
import org.springframework.transaction.support.ResourceTransactionManager;

/**
 * CB3BeanFactorỹeXgP[XB
 * @author Naoko Sugimoto
 */
public class CB3BeanFactoryTest {

	/** ݒt@CfBNg */
	private static String TEST_CONFIG_PATH = "jp/co/cybec/cb3/util/CB3BeanFactory/applicationContext.xml";

	/**
	 * {@link jp.co.cybec.cb3.util.CB3BeanFactory#getInstance()} ̂߂̃eXgE\bhB
	 * VOgɂȂĂ邱ƂmFB
	 */
	@Test
	public void testGetInstance() {
		Assert.assertSame(CB3BeanFactory.getInstance(), CB3BeanFactory.getInstance());
	}

	/**
	 * {@link jp.co.cybec.cb3.util.CB3BeanFactory#getBean(java.lang.String)} ̂߂̃eXgE\bhB
	 * Bean擾ł邱ƂmFB
	 */
	@Test
	public void testGetBean() {

		// eXgp̃ReLXgt@CpXgp
		CB3BeanFactory.getInstance().setApplicationContextFilePath(TEST_CONFIG_PATH);

		// gUNV}l[W擾B
		ResourceTransactionManager transactionManager = (ResourceTransactionManager)CB3BeanFactory.getInstance().getBean("transactionManager");
		Assert.assertNotNull(transactionManager);

		// f[^\[X擾B
		DataSource dataSource = (DataSource)CB3BeanFactory.getInstance().getBean("dataSource");
		Assert.assertNotNull(dataSource);
	}

	/**
	 * {@link CB3BeanFactory#setApplicationContextFilePath(String)} ̂߂̃eXgE\bhB<br>
	 * {@link CB3BeanFactory#setApplicationContextFilePath(String)}Őݒ肵t@CpXA
	 * {@link CB3BeanFactory#getApplicationContextFilePath()}ŕԂ邱ƂmFB
	 */
	@Test
	public void testServiceContextFilePath() {
		CB3BeanFactory factory = CB3BeanFactory.getInstance();

		factory.setApplicationContextFilePath(TEST_CONFIG_PATH);
		Assert.assertEquals(TEST_CONFIG_PATH, factory.getApplicationContextFilePath());
	}

	/**
	 * {@link CB3BeanFactory#getApplicationContextFilePath()} ̂߂̃eXgE\bhB<br>
	 * t@CpXnullw肵ƂA{@link CB3BeanFactory#getApplicationContextFilePath()}ł
	 * ftHg̃t@CpXԂ邱ƂmFB
	 */
	@Test
	public void testDefaultAccessorContextFilePath() {

		CB3BeanFactory factory = CB3BeanFactory.getInstance();

		factory.setApplicationContextFilePath(null);
		Assert.assertEquals("applicationContext.xml", factory.getApplicationContextFilePath());
	}
}
