/*
 * ValidationEntityResolverTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util;

import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.util.ValidationEntityResolver;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.InputSource;

/**
 * ValidationEntityResolver̃eXgP[XB
 * @author Juanjuan Wang
 */
public class ValidationEntityResolverTest {

	/** VXeID */
	private static final String SYSTEM_ID = "file:/D:/eclipse/workspace/CB3_Core/src/test/config/schema/XMLFileReaderConfig.xsd";

	/** pubNID */
	private static final String PUBLIC_ID = "XMLFileReaderConfig22.xsd";

	/** ݒt@C */
	private static final String CONFIG_FILE = "jp/co/cybec/cb3/accessor/fileaccess/xml/reader1Config.xml";

	private ValidationEntityResolver target = null;

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		target = new ValidationEntityResolver();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * {@link ValidationEntityResolver#resolveEntity(String, String)} ̂߂̃eXgE\bhB
	 * XMLXL[}t@CGeBeB擾ł邱ƂmFB
	 */
	@Test
	public void testResolveEntity() throws Exception{
		InputSource actual = target.resolveEntity(null, SYSTEM_ID);
		String expected = "XMLFileReaderConfig.xsd";
		Assert.assertEquals(expected, actual.getSystemId().substring(
				actual.getSystemId().length() - expected.length()));
	}

	/**
	 * {@link ValidationEntityResolver#resolveEntity(String, String)} ̂߂̃eXgE\bhB
	 * t@C(entityURL)NULL̏ꍇAO邱ƂmFB
	 */
	@Test(expected = ConfigFileDefinitionException.class)
	public void testResolveEntityConfigFileDefinitionException01() throws Exception {
		target.resolveEntity(null, null);
	}

	/**
	 * {@link ValidationEntityResolver#resolveEntity(String, String)} ̂߂̃eXgE\bhB
	 * XMLXL[}t@C݂ȂꍇAO邱ƂmFB
	 */
	@Test(expected = ConfigFileDefinitionException.class)
	public void testResolveEntityConfigFileDefinitionException02() throws Exception {
		target.resolveEntity(PUBLIC_ID, null);
	}

	/**
	 * {@link ValidationEntityResolver#setXmlFile(java.net.URL)} ̂߂̃eXgE\bhB
	 * XMLt@Cݒ肵ƂɗOȂƂmFB
	 */
	@Test
	public void testSetXmlFile() {
		target.setXmlFile(ConfigurationLoader.
				class.getClassLoader().getResource(CONFIG_FILE));
	}

}
