/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.util;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.util.ValidationEntityResolver;
import jp.co.cybec.cb3.util.ValidationErrorHandler;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.digester.xmlrules.XmlLoadException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class ConfigurationLoader {
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private static final String EXTENSION_XML = "xml";

    public static Object load(String rule, String config) throws ConfigFileNotFoundException, ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {
        String ruleFile = ConfigurationLoader.toFileName(rule);
        String configFile = ConfigurationLoader.toFileName(config);
        URL ruleUrl = ConfigurationLoader.class.getClassLoader().getResource(ruleFile);
        if (ruleUrl == null) {
            throw new ConfigFileNotFoundException(MESSAGE.getErrorMessage("UTIL.001", "CB3.UTIL.006", rule));
        }
        URL configUrl = ConfigurationLoader.class.getClassLoader().getResource(configFile);
        if (configUrl == null) {
            throw new ConfigFileNotFoundException(MESSAGE.getErrorMessage("UTIL.002", "CB3.UTIL.006", config));
        }
        return ConfigurationLoader.load(ruleUrl, configUrl);
    }

    public static Object load(URL rule, URL config) throws ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {
        try {
            Digester digester = DigesterLoader.createDigester((URL)rule);
            digester.setNamespaceAware(true);
            digester.setValidating(true);
            digester.setUseContextClassLoader(true);
            digester.setFeature("http://xml.org/sax/features/validation", true);
            digester.setFeature("http://apache.org/xml/features/validation/schema", true);
            digester.setFeature("http://xml.org/sax/features/namespaces", true);
            ValidationErrorHandler myErrorHandler = new ValidationErrorHandler();
            digester.setErrorHandler((ErrorHandler)myErrorHandler);
            ValidationEntityResolver schemaResolver = new ValidationEntityResolver();
            schemaResolver.setXmlFile(config);
            digester.setEntityResolver((EntityResolver)schemaResolver);
            Object object = digester.parse(config);
            if (!myErrorHandler.isValid()) {
                throw new ConfigFileDefinitionException(MESSAGE.getErrorMessage("UTIL.003", "CB3.UTIL.002", config));
            }
            if (object == null) {
                throw new ConfigFileDefinitionException(MESSAGE.getErrorMessage("UTIL.004", "CB3.UTIL.003", config));
            }
            return object;
        }
        catch (IOException e) {
            throw new ConfigFileIOException(MESSAGE.getErrorMessage("UTIL.005", "CB3.UTIL.003", config), e);
        }
        catch (SAXException e) {
            throw new ConfigFileParseException(MESSAGE.getErrorMessage("UTIL.006", "CB3.UTIL.004", config), e);
        }
        catch (XmlLoadException e) {
            throw new ConfigFileParseException(MESSAGE.getErrorMessage("UTIL.007", "CB3.UTIL.004", config), (Exception)((Object)e));
        }
        catch (ParserConfigurationException e) {
            throw new ConfigFileParseException(MESSAGE.getErrorMessage("UTIL.008", "CB3.UTIL.004", config), e);
        }
    }

    private static String toFileName(String value) {
        String filename = value;
        String extension = null;
        int point = filename.lastIndexOf(".");
        if (point != -1) {
            extension = filename.substring(point + 1);
        }
        if (extension == null || !extension.equalsIgnoreCase(EXTENSION_XML)) {
            filename = filename + "." + EXTENSION_XML;
        }
        return filename;
    }
}

