/*
 * DelimitedWriteFormatter.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.sample.file.delimited;

import java.math.BigDecimal;
import java.text.DecimalFormat;

import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldWriterFormatable;
import jp.co.cybec.cb3.exception.DataFormatException;

/**
 * t@CC^[̓ƎtH[}bgNX
 *
 * @author Nobuyuki Tokumaru
 */
public class DelimitedWriteFormatter implements RecordFieldWriterFormatable {
	/**
	 * tH[}bgs - ߂ɌĂяo
	 */
	public String format(String pattern, String type, String data)
			throws DataFormatException {
		System.out.println("called format method");
		System.out.println("pattern:" + pattern + " type:" + type + " data:" + data);
		System.out.println("");

		DecimalFormat df = new DecimalFormat();
		df.applyPattern(pattern);

		return  df.format(new BigDecimal(data));
	}

	/**
	 * pfBOs - format\bh̎ɌĂяo
	 */
	public String padding(String length, String algin, String padding, String data)
			throws DataFormatException {
		System.out.println("called padding method");
		System.out.println("length:" + length + " algin:" + algin + " padding:" + padding + " data:" + data);
		System.out.println("");

		return data;
	}
}
