/*
 * FixedLengthSample2.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.sample.file.fixed;

import java.util.HashMap;

import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordReader;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordWriter;
import jp.co.cybec.cb3.container.service.CB3Service;
import jp.co.cybec.cb3.exception.ServiceException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;

/**
 * Œ蒷t@CANZX̃TvNX
 *
 * @author Teruhisa Abe
 */
public class FixedLengthSample2 extends CB3Service {

	/**
	 * Œ蒷t@Cւ݂̏Ɠǂݍ݂sB
	 */
	@Override
	protected int doService(ServiceParameters serviceparameters,
			RuntimeParameters runtimeparameters) throws ServiceException {
		fileWrite();
		fileRead();
		return 0;
	}

	/**
	 * t@Cւ݂̏s
	 */
	private void fileWrite(){
		FlatFileRecordWriter writer = (FlatFileRecordWriter)getDataAccessContext().lookup("writerConfig2");
		// t@CI[v
		writer.open();

		// ǉf[^ݒ肷
		HashMap<String, String> data = new HashMap<String, String>();
		data.put("name","tanaka");
		data.put("staffId","11");
		data.put("staffSubId","12");
		// datȅꍇ̓ftHǧ`Őݒs yyyy/MM/dd HH:mm:ss
		data.put("registrationDate","2008/01/01 00:00:00");

		// s̃f[^ǉR[h𐶐
		FlatFileRecord record = writer.createFlatFileRecord(data);

		// t@Cւ̏
		writer.write(record);

		// t@CN[Y
		writer.close();
	}

	/**
	 * t@C̓ǂݍ݂s
	 */
	private void fileRead(){
		FlatFileRecordReader reader = (FlatFileRecordReader)getDataAccessContext().lookup("readerConfig2");
		// ǂݍރt@CI[v
		reader.open();

		FlatFileRecord record = null;
		System.out.println("ǂݍ݌:fixedtest2.txt");

		while((record = reader.nextRecord()) != null ){
			System.out.println("name:" + record.getString("name"));
			System.out.println("staffId:" + record.getString("staffId"));
			System.out.println("staffSubId:" + record.getString("staffSubId"));
			System.out.println("registrationDate:" + record.getString("registrationDate"));
		}
	}
}
