/*
 * Namespace.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.sample.xml.namespace;

import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLElement;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLFileReader;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLFileWriter;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLPath;
import jp.co.cybec.cb3.container.service.CB3Service;
import jp.co.cybec.cb3.exception.ServiceException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;

/**
 * l[Xy[X֌W̃TvXML̏o͂AXQuerygēǂݍ݂TvNXB
 * @author Teruhisa Abe
 */
public class Namespace extends CB3Service {

	/**
	 * XMLt@Cւ݂̏Ɠǂݍ݂sB
	 */
	@Override
	protected int doService(ServiceParameters serviceparameters,
			RuntimeParameters runtimeparameters) throws ServiceException {
		fileWrite();
		fileRead();
		return 0;
	}

	/**
	 * XMLt@Cւ݂̏s
	 */
	private void fileWrite(){

		XMLFileWriter writer = (XMLFileWriter)getDataAccessContext().lookup("writerConfig");
		writer.open();

		XMLElement element = new XMLElement("cb3");
		//OURIw肷
		element.setURI("http://www.cybec.co.jp/cb3");
		element.setString("welcome");

		//OURIƖOԂ̐ړw肷
		writer.addNamespace("http://www.cybec.co.jp/cb3","cybec");
		writer.dataElement(element);
		writer.close();
	}

	/**
	 * t@C̓ǂݍ݂s
	 */
	private void fileRead(){
		XMLFileReader reader = (XMLFileReader)getDataAccessContext().lookup("readerConfig");
		reader.open();

		//XQuerygAcybec:cb3^Oǂݍ
		XMLPath path = reader.selectPath(
				"declare namespace cybec = 'http://www.cybec.co.jp/cb3'$this//cybec:cb3");

		//^O̗vfAvfo
		XMLElement cb3 = path.next();
		System.out.println("vf = [" + cb3.getName() + "],  vf = [" + cb3.getString() + "]");
		reader.close();
	}

}
