/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: complex.c,v 1.1 2003/10/05 10:02:10 tsutsumi Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "complex.h"

complex_t* complex_new (double real, double imaginary)
{
  complex_t* cp = calloc (1, sizeof (complex_t));
  if (!cp)
    return NULL;
  cp->real = real;
  cp->imaginary = imaginary;
  return cp;
}

inline void complex_delete (const complex_t* cp)
{
  free ((complex_t*)cp);
}

char* complex_to_string (const complex_t* cp)
{
  char* str = calloc (40, sizeof (char));
  snprintf (str, 40, "%g%+gi", cp->real, cp->imaginary);
  return str;
}

complex_t* complex_add (complex_t* z, const complex_t* x, const complex_t* y)
{
  z->real = x->real + y->real;
  z->imaginary = x->imaginary + y->imaginary;
  return z;
}

complex_t* complex_sub (complex_t* z, const complex_t* x, const complex_t* y)
{
  z->real = x->real - y->real;
  z->imaginary = x->imaginary - y->imaginary;
  return z;
}

complex_t* complex_mul (complex_t* z, const complex_t* x, const complex_t* y)
{
  complex_t c;
  c.real = x->real * y->real - x->imaginary * y->imaginary;
  c.imaginary = x->real * y->imaginary + x->imaginary * y->real;
  *z = c;
  return z;
}

complex_t* complex_div (complex_t* z, const complex_t* x, const complex_t* y)
{
  const double r2 = y->real * y->real + y->imaginary * y->imaginary;
  complex_t c;
  c.real = (x->real * y->real + x->imaginary * y->imaginary) / r2;
  c.imaginary = (x->imaginary * y->real - x->real * y->imaginary) / r2;
  *z = c;
  return z;
}

inline int complex_equals (const complex_t*x, const complex_t* y)
{
  return x->real == y->real && x->imaginary == y->imaginary;
}
