/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: complexTestSuite.c,v 1.1 2003/10/05 10:02:10 tsutsumi Exp $
 */

#include <ccunit/CCUnitTestSuite.h>

void setUp_complex_test ();
void tearDown_complex_test ();
void test_complex_equals ();
void test_complex_add ();
void test_complex_sub ();

void setUp_complex_mul_div ();
void tearDown_complex_mul_div ();
void test_complex_mul ();
void test_complex_div ();

CCUnitTestSuite* complex_add_sub_suite ()
{
  CCUnitTestFixture* fixture;
  CCUnitTestSuite* suite;
  fixture = ccunit_newTestFixture ("complex add sub test",
                                   CCUNIT_NEWTESTFUNC(setUp_complex_test),
                                   CCUNIT_NEWTESTFUNC(tearDown_complex_test));
  ccunit_addNewTestCase (fixture, 
                         "test_complex_equals",
                         "complex equals test",
                         test_complex_equals);
  ccunit_addNewTestCase (fixture,
                         "test_complex_add",
                         "complex add test",
                         test_complex_add);
  ccunit_addNewTestCase (fixture,
                         "test_complex_sub",
                         "complex sub test",
                         test_complex_sub);
  suite = ccunit_newTestSuite ("complex add/sub test");
  ccunit_addTestFixture (suite, fixture);
  return suite;
}

CCUnitTestSuite* complex_mul_div_suite ()
{
  CCUnitTestFixture* fixture;
  CCUnitTestSuite* suite;
  fixture = ccunit_newTestFixture ("complex mul div test",
                                   CCUNIT_NEWTESTFUNC(setUp_complex_mul_div),
                                   CCUNIT_NEWTESTFUNC(tearDown_complex_mul_div));
  ccunit_addNewTestCase (fixture, 
                         "test_complex_mul",
                         "complex mul test",
                         test_complex_mul);
  ccunit_addNewTestCase (fixture,
                         "test_complex_div",
                         "complex div test",
                         test_complex_div);
  suite = ccunit_newTestSuite ("complex mul/div test");
  ccunit_addTestFixture (suite, fixture);
  return suite;
}
