/* -*- C -*- */
/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: CCUnitConfig.h,v 1.8 2003/10/01 20:36:00 tsutsumi Exp $
 */

/** @file
 * CCUnit configrations.
 */
#ifndef CCUNITCONFIG_H
#define CCUNITCONFIG_H

#include <ccunit/config.h>

#if CCUNIT_STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#if CCUNIT_WITH_DMALLOC
#  include <dmalloc.h>
#endif

#if CCUNIT_HAVE_STDBOOL_H
#include <stdbool.h>
#elif defined (__cplusplus)
#elif CCUNIT_HAVE__BOOL
#define bool _Bool				/**< boolean */
#define true ((bool)1)				/**< true */
#define false ((bool)0)				/**< false */
#elif !defined (bool)
#define bool int				/**< boolean */
#define true (1)				/**< true */
#define false (0)				/**< false */
#endif

/**
 * safty free memory.
 * Omits dmalloc's free(NULL) warning.
 * @param p [in/out] pointer to free. and set NULL.
 */
#define safe_free(p) (!p ? NULL : (free (p), p = NULL))

/**
 * safty strdup. Tries not to pass NULL to strdup.
 * @param s string to duplicate.
 * @return duplicated string, or NULL when error occured.
 */
#define safe_strdup(s) (!s ? NULL : strdup (s))

#endif
