/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: failAssert.c,v 1.4 2003/10/01 20:56:36 tsutsumi Exp $
 */
#include <stdio.h>
#include <limits.h>
#include <ccunit/CCUnitAssert.h>

#include "failAssert.h"

/** test case: assert macro test */

/**
 * assert fail.
 */
static void test_assert_fail ()
{
  CCUNIT_ASSERT (1 == 0);
}

/**
 * assert eq int fail.
 */
static void test_assertInt_equal ()
{
  CCUNIT_ASSERT_EQ_INT (INT_MAX, INT_MIN);
}

/**
 * assert !eq int fail
 */
static void test_assertInt_notEqual ()
{
  CCUNIT_ASSERT_NE_INT (INT_MAX, INT_MAX);
}

/**
 * assert int compare fail
 */
static void test_assertInt_comp_fail ()
{
  CCUNIT_ASSERT_GT_INT (INT_MIN, INT_MAX);
}

/**
 * assert str compare fail
 */
static void test_assertStr_comp_fail ()
{
  CCUNIT_ASSERT_EQ_STR ("string", "STRING");
}

/** end test case */

/** test case: assert setUp() */

static void setUp_setUp ()
{
  CCUNIT_ASSERT_EQ_STR ("setUp", "");
}

/** not reached */
static void tearDown_setUp ()
{
  CCUNIT_ASSERT (false);
}

/** not reached */
static void test_setUp ()
{
  CCUNIT_ASSERT(false);
}

/** end test case */

/** test case: assert tearDown() */

static void tearDown_tearDown ()
{
  CCUNIT_ASSERT_EQ_STR ("tearDown", "");
}

/** be failed */
static void test_tearUp ()
{
  CCUNIT_ASSERT(false);
}

/** end test case */
