/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: testComplex.c,v 1.1 2003/10/05 10:02:10 tsutsumi Exp $
 */

#include <ccunit/CCUnitAssert.h>

/** TEST CASE: complex number test */

#include <complex.h>

static complex_t* s10_1;
static complex_t* s1_1;
static complex_t* s11_2;

void setUp_complex_test ()
{
  s10_1 = complex_new (10, 1);
  s1_1 = complex_new (1, 1);
  s11_2 = complex_new (11, 2);
}
 
void tearDown_complex_test ()
{
  complex_delete (s10_1);
  complex_delete (s1_1);
  complex_delete (s11_2);
}

/** test equals */
void test_complex_equals ()
{
  CCUNIT_ASSERT_TEST_OBJ (s10_1, complex_equals, s10_1, complex_to_string);
  CCUNIT_ASSERT_TEST_OBJ (s10_1, !complex_equals, s1_1, complex_to_string);
}

/** test add */
void test_complex_add ()
{
  complex_t c10_1 = { 10.0, 1.0 };
  complex_t c1_1 = { 1.0, 1.0 };
  complex_t result;
  complex_t c11_2 = { 11.0, 2.0 };
  CCUNIT_ASSERT (complex_equals (&c11_2, complex_add (&result, &c10_1, &c1_1)));
}

/** test sub */
void test_complex_sub ()
{
  complex_t c9_0 = { 9, 0 };
  complex_t result;
  CCUNIT_ASSERT_TEST_OBJ (&c9_0, complex_equals,
			  complex_sub (&result, s10_1, s1_1),
			  complex_to_string);
}

/** end test case */
