/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: testComplexMulDiv.c,v 1.1 2003/10/05 10:02:10 tsutsumi Exp $
 */

#include <ccunit/CCUnitAssert.h>

/** TEST SUITE: complex mul div test suite */

/** TEST CASE: complex number mul/div test */

#include <complex.h>

static complex_t* s6_3;
static complex_t* s3_2;
static complex_t* smul;
static complex_t* sdiv;

void setUp_complex_mul_div ()
{
  const double r2 = 3*3 + 2*2;
  s6_3 = complex_new (6, 3);
  s3_2 = complex_new (3, 2);
  smul = complex_new (6*3 - 3*2, 6*2 + 3*3);
  sdiv = complex_new ((6*3 + 3*2)/r2, (3*3 - 6*2)/r2);
}
 
void tearDown_complex_mul_div ()
{
  complex_delete (s6_3);
  complex_delete (s3_2);
  complex_delete (smul);
  complex_delete (sdiv);
}

void test_complex_mul ()
{
  complex_t result;
  CCUNIT_ASSERT_TEST_OBJ (smul, complex_equals,
			  complex_mul (&result, s6_3, s3_2),
			  complex_to_string);
}

void test_complex_div ()
{
  complex_t result;
  CCUNIT_ASSERT_TEST_OBJ (sdiv, complex_equals,
			  complex_div (&result, s6_3, s3_2),
			  complex_to_string);
}
