/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: testReadSuite.c,v 1.3 2003/10/05 12:17:37 tsutsumi Exp $
 */
#include <stdio.h>
#include <ccunit/CCUnit.h>

/** @file
 * test suite: read test suite file.
 */

/**
 * @defgroup testReadSuite ccuint_readSuite test.
 */

/**
 * log file input stream.
 */
static FILE* lfp;

static const char* logname = "testReadSuite.log";

static char line[1024];

/** @ingroup testReadSuite
 * test case: read test suite init
 * @{
 */

/**
 * test init.
 */
void test_readSuite_init ()
{
  int rc;
  FILE* fp;
  fp = freopen (logname, "w", stderr);
  CCUNIT_ASSERT_NOT_NULL (fp);
  rc = ccunit_va_makeSuite ("testReadSuite", "-v",
			    "-o", "suiteReadSuite.log", "testReadSuite.c", NULL);
  CCUNIT_ASSERT_EQ_INT (0, rc);
  fclose (fp);
}

/** @}
 * end test case: read test suite init
 */

/** @ingroup testReadSuite
 * test case: read test suite
 */

/**
 * setup readSuite.
 */
void setUp_readSuite ()
{
  lfp = fopen (logname, "r");
  CCUNIT_ASSERT_NOT_NULL (lfp);
}

/**
 * teardown readSuite
 */
void tearDown_readSuite ()
{
  fclose (lfp);
}

/**
 * test skip doxycomment.
 */
void test_readSuite_skip_doxycomment ()
{
  bool found = false;
  while (fgets (line, sizeof (line), lfp) != NULL)
    {
      char* content = strstr (line, "comment content: ");
      if (content && strcmp (content, "comment content: "
			     "\"test suite: read test suite file.\"\n") == 0)
	{
	  found = true;
	  return;
	}
    }
  CCUNIT_ASSERT_EQ_INT (true, found);
}


/**
 * end test case
 */
/**
 * end test suite
 */
