#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QCloseEvent>
#include "data.h"
#include "coronawindow.h"
#include "memewindow.h"
#include "owncoronaform.h"
#include "possibletokugiform.h"
#include "applicationninformaitonform.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();
    virtual bool setGeneral(Data* general);
    virtual bool setCoronaWindow(CoronaWindow*);
    virtual bool setMemeWindow(MemeWindow*);
    virtual bool setOwnCoronaForm(OwnCoronaForm*);
    virtual bool setPossibleTokugiForm(PossibleTokugiForm*);
    virtual QString GetWritenTokugi(Data* parent);

protected:
    void changeEvent(QEvent *e);
    void closeEvent(QCloseEvent *event);

private:
    Ui::MainWindow *ui;
    Data* _general;
    CoronaWindow* _cw;
    MemeWindow* _mw;
    OwnCoronaForm* _ocf;
    PossibleTokugiForm* _ptf;
    ApplicationnInformaitonForm *_aif;

signals:
    void checkOwn();
    void applicationExit();

public slots:
    void hideApplicationInformationForm();

private slots:
    void on_applicationExit_triggered();
    void on_action_triggered();
    void on_action_3_triggered();
    void on_action_2_triggered();
    void on_action_4_triggered();
    void on_action_5_triggered();
    void on_applicationInformation_triggered();
};

#endif // MAINWINDOW_H
