#!/usr/bin/perl
#
# cgigenerator.pl
#
# Copyright (C) 2009 Hidetaka Sakai
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
#
# =======================
# This program convert jsp style text to Apache cgi c program .
# This is fileter program.
#
# usage :
#   - help usage 
#     ./cgigenerator.pl -h  
#
#   - option use
#     ./cgigenerator.pl -i <srcfile> -o <dstfile>
#   - filetr program
#     ./cgigenerator.pl < <srcfile> > <dstfile>
#
#   - printf change
#     ./cgigenerator.pl -f samprintf -i <srcfile> -o <dstfile>
#
# can use tags:
#   - C progaram 
#     <%  
#      ....
#     %>
#     -> not convert 
#   - numeric value
#     <%d=1%>
#     -> printf( "%d", 1 );
#   - string value
#     <%d="sample"%>
#     -> printf( "%s", "samble" );
#   - normal string
#     <input type="text" name="sample1" value="ok">
#     -> printf( "<input type=\"text\" name=\"sample1\" value=\"ok\">\n" );
# 
#  you can read sample dir.
#
#
#

my $PRGNAM= "cgigenerator.pl";

sub usage(){
print( " $PRGNAM usage : \n" );
print( "   - help usage \n");
print( "     ./cgigenerator.pl -h  \n");
print( "\n");
print( "   - option use\n");
print( "     ./cgigenerator.pl -i <srcfile> -o <dstfile>\n");
print( "   - filetr program\n");
print( "     ./cgigenerator.pl < <srcfile> > <dstfile>\n");
print( "\n");
print( "   - printf change\n");
print( "     ./cgigenerator.pl -f samprintf -i <srcfile> -o <dstfile>\n");
print( "\n");
print( " can use tags:\n");
print( "   - C progaram \n");
print( "     <%  \n");
print( "      ....\n");
print( "     %>\n");
print( "     -> not convert \n");
print( "   - numeric value\n");
print( "     <%d=1%>\n");
print( "     -> printf( \"%d\", 1 );\n");
print( "   - string value\n");
print( "     <%d=\"sample\"%>\n");
print( "     -> printf( \"%s\", \"samble\" );\n");
print( "   - normal string\n");
print( "     <input type=\"text\" name=\"sample1\" value=\"ok\">\n");
print( "     -> printf( \"<input type=\\\"text\\\" name=\\\"sample1\\\" value=\\\"ok\\\">\\n\" );\n");
print( " \n");
print( "  you can read sample dir. \n" );
}



use Getopt::Std;

# my $DEBUG = 1;

################################
# parameter valiable
################################
my $MODE_HTML = 0;
my $MODE_C    = 1;
my $PRINTFUNC_ST = "printf(";
my $PRINTFUNC_ED = ")";
my $INPUTFILENM  = "STDIN";
my $OUTPUTFILENM = "STDOUT";
my $mode = $MODE_HTML; 
my @lines ;

my %opts = ();

################################
# option parse
################################
getopts ("i:o:f:h", \%opts);
# foreach $key(keys %opts ) {
#   print "$key = $opts{$key}\n";
#}
if( exists $opts{"h"}  ) {
	usage();
	exit(0);
}
if( exists $opts{"f"}  ) {
	my $tmp = $opts{"f"} ;
	$PRINTFUNC_ST = "$tmp(";
}
if( exists $opts{"o"}  ) {
	$OUTPUTFILENM= $opts{"o"};
	if( !  open( STDOUT, "> $OUTPUTFILENM" ) ) {
		die("can't open($OUTPUTFILENM) :$!");
	}
}
if( exists $opts{"i"}  ) {
	$INPUTFILENM = $opts{"i"};
	if( !  open( IN, "< $INPUTFILENM" ) ) {
		die("can't open($INPUTFILENM) :$!");
	}
	@lines = <IN>;
	close( IN );	
}else{
	# read stdin;
	@lines = <STDIN>;
}



################################
# temporary valiable
################################
my $linestr="";
my $linecnt=0;
my $tmpstr = "";
my $printstr = "";

################################
# Start Convert
################################
print(  "#line 1 \"$INPUTFILENM\"\n" );
foreach $linestr (@lines) {
	$linecnt++;
	$tmpstr = $linestr;

#print "@ line:$linecnt -> mode:$mode tmpstr:$tmpstr \n";
	while( ( $tmpstr =~ /^[\r\n]+$/) || ( $tmpstr !~ /^$/ ) ) {
		if( $DEBUG ){
			my $dbgstr = $tmpstr;
			$dbgstr =~ s/\r/\\r/g;
			$dbgstr =~ s/\n/\\n/g;
			print "@ line:$linecnt -> mode:$mode tmpstr:$dbgstr \n";
		}
		if( $mode == $MODE_HTML ){
			# mode HTML
			# search <%s
			if( $tmpstr =~ /^(.*?)?<%(.*[\r\n]*)?/ ){
				$printstr = $1;
				$tmpstr   = $2;
				$mode = $MODE_C;
			} else {
				# not found <%
				$printstr = $tmpstr;
				if( $printstr =~ /^$/ ){
					$printstr = "";
				}
				$tmpstr = "";
			}
			$printstr =~ s/"/\\"/g;
			$printstr =~ s/\r/\\r/g;
			$printstr =~ s/\n/\\n/g;
			if( length( $printstr ) != 0  ){
				print(  "$PRINTFUNC_ST \"$printstr\" $PRINTFUNC_ED;\n" );
			}
			print(  "#line $linecnt \"$INPUTFILENM\"\n" );
			next;
		} else {
			# mode C
			# search %>
			# if( $tmpstr =~ /^(.*)?%>(.*)?$/ ){
			if( $tmpstr =~ /^(.*?)?%>(.*[\r\n]*)?$/ ){
				$printstr = $1;
				$tmpstr   = $2;
				$mode = $MODE_HTML;
			} else {
				$printstr = $tmpstr;
				$tmpstr = "";
			}
#			print( $$OUTFD $printstr );
			if( $printstr =~ /^d=(.*)$/ ){
				print(  "$PRINTFUNC_ST \"%d\", $1 $PRINTFUNC_ED;" );
			}elsif( $printstr =~ /^s=(.*)$/ ){
				print(  "$PRINTFUNC_ST \"%s\", $1 $PRINTFUNC_ED;" );
			}else{
				print(  $printstr );
			}

			if( $printstr !~ /\n/g ){
#				print $$OUTFD "\n" ;
				print "\n" ;
			}
			next;
		}
	}	
}

if( exists $opts{"o"}  ) {
	close( STDOUT, "> $OUTPUTFILENM" );
}

