/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj;

import charactermanaj.clipboardSupport.ImageSelection;
import charactermanaj.model.AppConfig;
import charactermanaj.model.util.StartupSupport;
import charactermanaj.ui.MainFrame;
import charactermanaj.ui.ProfileListManager;
import charactermanaj.ui.SelectCharatersDirDialog;
import charactermanaj.util.AWTExceptionLoggingHandler;
import charactermanaj.util.ApplicationLoggerConfigurator;
import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.DirectoryConfig;
import charactermanaj.util.ErrorMessageHelper;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public final class Main
implements Runnable {
    private static final Logger logger = Logger.getLogger(Main.class.getName());
    private static final boolean isMacOSX;
    private static final boolean isLinuxOrMacOSX;

    private static void initLogger() {
        try {
            ApplicationLoggerConfigurator.configure();
            System.setProperty("sun.awt.exception.handler", AWTExceptionLoggingHandler.class.getName());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "logger initiation failed. " + ex, ex);
        }
    }

    private static void setupUIManager() throws Exception {
        if (Main.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "CharacterManaJ");
        }
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        UIManager.put("Slider.paintValue", Boolean.FALSE);
        Object textFieldFontUI = UIManager.get("TextField.font");
        if (textFieldFontUI == null) {
            textFieldFontUI = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"dialog", 0, 12});
        }
        UIManager.put("TextArea.font", textFieldFontUI);
    }

    public void run() {
        try {
            File defaultCharacterDir;
            File currentCharacterDir;
            try {
                Main.setupUIManager();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.log(Level.WARNING, "UIManager setup failed.", ex);
            }
            AppConfig appConfig = AppConfig.getInstance();
            appConfig.loadConfig();
            if (!ImageSelection.setupSystemFlavorMap()) {
                logger.log(Level.WARNING, "failed to set the clipboard-support.");
            }
            if ((currentCharacterDir = SelectCharatersDirDialog.getCharacterDir(defaultCharacterDir = ConfigurationDirUtilities.getDefaultCharactersDir())) == null) {
                logger.info("luncher canceled.");
                return;
            }
            DirectoryConfig.getInstance().setCharactersDir(currentCharacterDir);
            StartupSupport.getInstance().doStartup();
            MainFrame mainFrame = ProfileListManager.openDefaultProfile();
            if (Main.isMacOSX()) {
                Class<?> clz = Class.forName("charactermanaj.ui.MainFramePartialForMacOSX");
                Method mtd = clz.getMethod("setupScreenMenu", MainFrame.class);
                mtd.invoke(null, mainFrame);
            }
            mainFrame.showMainFrame();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "Application initiation failed.", ex);
            ErrorMessageHelper.showErrorDialog(null, ex);
            MainFrame.closeAllProfiles();
        }
    }

    public static void main(String[] args) {
        Main.initLogger();
        SwingUtilities.invokeLater(new Main());
    }

    public static boolean isMacOSX() {
        return isMacOSX;
    }

    public static boolean isLinuxOrMacOSX() {
        return isLinuxOrMacOSX;
    }

    static {
        String lcOS = System.getProperty("os.name").toLowerCase();
        isMacOSX = lcOS.startsWith("mac os x");
        isLinuxOrMacOSX = isMacOSX || lcOS.indexOf("linux") >= 0;
    }
}

