/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.RecentData;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.util.DirectoryConfig;
import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RecentDataPersistent {
    private static final Logger logger = Logger.getLogger(RecentDataPersistent.class.getName());
    private static final RecentDataPersistent inst = new RecentDataPersistent();
    private static final String RECENT_CHARACTER_SER = "recent-character.ser";

    private RecentDataPersistent() {
    }

    public static RecentDataPersistent getInstance() {
        return inst;
    }

    public void saveRecent(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        if (!characterData.isValid()) {
            return;
        }
        AppConfig appConfig = AppConfig.getInstance();
        RecentData recentData = new RecentData();
        recentData.setAppVersion(appConfig.getSpecificationVersion());
        recentData.setDocBase(characterData.getDocBase());
        UserData recentCharacterStore = this.getRecentCharacterStore();
        HashMap<File, RecentData> recentDataMap = new HashMap<File, RecentData>();
        try {
            Object rawRecentData;
            if (recentCharacterStore.exists() && (rawRecentData = recentCharacterStore.load()) instanceof Map) {
                Map prevRecentDataMap = (Map)rawRecentData;
                for (Map.Entry entry : prevRecentDataMap.entrySet()) {
                    File dir = (File)entry.getKey();
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    RecentData prevRecentData = (RecentData)entry.getValue();
                    recentDataMap.put(dir, prevRecentData);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "old recentDataFile load failed.", ex);
        }
        File currentCharactersDir = DirectoryConfig.getInstance().getCharactersDir();
        recentDataMap.put(currentCharactersDir, recentData);
        recentCharacterStore.save(recentDataMap);
    }

    public CharacterData loadRecent() throws IOException {
        RecentData recentData;
        UserData recentCharacterStore = this.getRecentCharacterStore();
        if (!recentCharacterStore.exists()) {
            return null;
        }
        try {
            File currentCharactersDir = DirectoryConfig.getInstance().getCharactersDir();
            Object rawRecentData = recentCharacterStore.load();
            if (rawRecentData instanceof RecentData) {
                recentData = (RecentData)rawRecentData;
                logger.log(Level.INFO, "old-recentdata-type: " + recentData);
                URI uri = recentData.getDocBase();
                File parentDir = new File(uri).getParentFile().getParentFile();
                if (!currentCharactersDir.equals(parentDir)) {
                    logger.log(Level.INFO, "unmatched characters-dir. current=" + currentCharactersDir + "/recent=" + parentDir);
                    recentData = null;
                }
            } else if (rawRecentData instanceof Map) {
                Map recentDataMap = (Map)rawRecentData;
                recentData = (RecentData)recentDataMap.get(currentCharactersDir);
                logger.log(Level.FINE, "recent-data: " + currentCharactersDir + "=" + recentData);
            } else {
                logger.log(Level.SEVERE, "invalid file format. " + recentCharacterStore + "/class=" + rawRecentData.getClass());
                recentData = null;
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "recent data loading failed. " + recentCharacterStore, ex);
            recentData = null;
        }
        if (recentData != null) {
            CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
            return persist.loadProfile(recentData.getDocBase());
        }
        return null;
    }

    protected UserData getRecentCharacterStore() {
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        UserData recentCharacterStore = userDataFactory.getUserData(RECENT_CHARACTER_SER);
        return recentCharacterStore;
    }
}

