/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.filters.ColorConv;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.ui.ColorDialog;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColorDialogTabPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox cmbColorReplace;
    private JSpinner spinGray;
    private JSpinner spinOffsetR;
    private JSpinner spinOffsetG;
    private JSpinner spinOffsetB;
    private JSpinner spinOffsetA;
    private JSpinner spinFactorR;
    private JSpinner spinFactorG;
    private JSpinner spinFactorB;
    private JSpinner spinFactorA;
    private JSpinner spinHue;
    private JSpinner spinSaturation;
    private JSpinner spinBrightness;
    private JSpinner spinContrast;
    private JSpinner spinGammaR;
    private JSpinner spinGammaG;
    private JSpinner spinGammaB;
    private JSpinner spinGammaA;
    private JComboBox cmbColorGroup;
    private JCheckBox chkColorGroupSync;
    private final ColorDialog parent;
    private AtomicInteger changeEventDisableSemaphore = new AtomicInteger();
    private ColorConvertParameter paramOrg = new ColorConvertParameter();
    private ColorConvertParameter chachedParam;
    private LinkedList<ColorChangeListener> listeners = new LinkedList();

    public void addColorChangeListener(ColorChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public void removeColorChangeListener(ColorChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireColorChangeEvent(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        this.chachedParam = null;
        if (this.changeEventDisableSemaphore.get() <= 0) {
            ColorChangeEvent event = new ColorChangeEvent(this.parent, layer);
            for (ColorChangeListener listener : this.listeners) {
                listener.onColorChange(event);
            }
        }
    }

    protected void fireColorGroupChangeEvent(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        this.chachedParam = null;
        if (this.changeEventDisableSemaphore.get() <= 0) {
            ColorChangeEvent event = new ColorChangeEvent(this.parent, layer);
            for (ColorChangeListener listener : this.listeners) {
                listener.onColorGroupChange(event);
            }
        }
    }

    public ColorDialogTabPanel(ColorDialog parent, final Layer layer, Collection<ColorGroup> colorGroups) {
        if (parent == null || layer == null || colorGroups == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("languages/colordialog");
        this.setLayout(new BorderLayout());
        JPanel container = new JPanel();
        BoxLayout boxlayout = new BoxLayout(container, 3);
        container.setLayout(boxlayout);
        this.add((Component)container, "North");
        ChangeListener changeEventHandler = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ColorDialogTabPanel.this.fireColorChangeEvent(layer);
                ColorDialogTabPanel.this.firePropertyChange("colorConvertParameter", null, null);
            }
        };
        JPanel colorReplacePanel = new JPanel();
        colorReplacePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(strings.getProperty("group.replacergb.caption"))));
        GridBagLayout gbl = new GridBagLayout();
        colorReplacePanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel lblColorReplace = new JLabel(strings.getProperty("replacergb"), 4);
        this.cmbColorReplace = new JComboBox<ColorConv>(ColorConv.values());
        JLabel lblGray = new JLabel(strings.getProperty("bright"), 4);
        SpinnerNumberModel grayModel = new SpinnerNumberModel(1.0, 0.0, 1.0, 0.05);
        grayModel.addChangeListener(changeEventHandler);
        this.cmbColorReplace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorDialogTabPanel.this.fireColorChangeEvent(layer);
                ColorDialogTabPanel.this.firePropertyChange("colorConvertParameter", null, null);
            }
        });
        this.spinGray = new JSpinner(grayModel);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        colorReplacePanel.add((Component)lblColorReplace, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        colorReplacePanel.add((Component)this.cmbColorReplace, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        colorReplacePanel.add((Component)lblGray, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        colorReplacePanel.add((Component)this.spinGray, gbc);
        JPanel colorLevelPanel = new JPanel();
        colorLevelPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(strings.getProperty("group.rgb.caption"))));
        GridLayout gl = new GridLayout(4, 5);
        gl.setHgap(2);
        gl.setVgap(2);
        colorLevelPanel.setLayout(gl);
        colorLevelPanel.add(Box.createGlue());
        colorLevelPanel.add(new JLabel(strings.getProperty("red"), 0));
        colorLevelPanel.add(new JLabel(strings.getProperty("green"), 0));
        colorLevelPanel.add(new JLabel(strings.getProperty("blue"), 0));
        colorLevelPanel.add(new JLabel(strings.getProperty("alpha"), 0));
        colorLevelPanel.add(new JLabel(strings.getProperty("offset"), 4));
        SpinnerNumberModel offsetModelR = new SpinnerNumberModel(0, -255, 255, 1);
        SpinnerNumberModel offsetModelG = new SpinnerNumberModel(0, -255, 255, 1);
        SpinnerNumberModel offsetModelB = new SpinnerNumberModel(0, -255, 255, 1);
        SpinnerNumberModel offsetModelA = new SpinnerNumberModel(0, -255, 255, 1);
        offsetModelR.addChangeListener(changeEventHandler);
        offsetModelG.addChangeListener(changeEventHandler);
        offsetModelB.addChangeListener(changeEventHandler);
        offsetModelA.addChangeListener(changeEventHandler);
        this.spinOffsetR = new JSpinner(offsetModelR);
        this.spinOffsetG = new JSpinner(offsetModelG);
        this.spinOffsetB = new JSpinner(offsetModelB);
        this.spinOffsetA = new JSpinner(offsetModelA);
        colorLevelPanel.add(this.spinOffsetR);
        colorLevelPanel.add(this.spinOffsetG);
        colorLevelPanel.add(this.spinOffsetB);
        colorLevelPanel.add(this.spinOffsetA);
        colorLevelPanel.add(new JLabel(strings.getProperty("factor"), 4));
        SpinnerNumberModel factorModelR = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel factorModelG = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel factorModelB = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel factorModelA = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        factorModelR.addChangeListener(changeEventHandler);
        factorModelG.addChangeListener(changeEventHandler);
        factorModelB.addChangeListener(changeEventHandler);
        factorModelA.addChangeListener(changeEventHandler);
        this.spinFactorR = new JSpinner(factorModelR);
        this.spinFactorG = new JSpinner(factorModelG);
        this.spinFactorB = new JSpinner(factorModelB);
        this.spinFactorA = new JSpinner(factorModelA);
        colorLevelPanel.add(this.spinFactorR);
        colorLevelPanel.add(this.spinFactorG);
        colorLevelPanel.add(this.spinFactorB);
        colorLevelPanel.add(this.spinFactorA);
        colorLevelPanel.add(new JLabel(strings.getProperty("gamma"), 4));
        SpinnerNumberModel gammaModelR = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel gammaModelG = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel gammaModelB = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel gammaModelA = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        gammaModelR.addChangeListener(changeEventHandler);
        gammaModelG.addChangeListener(changeEventHandler);
        gammaModelB.addChangeListener(changeEventHandler);
        gammaModelA.addChangeListener(changeEventHandler);
        this.spinGammaR = new JSpinner(gammaModelR);
        this.spinGammaG = new JSpinner(gammaModelG);
        this.spinGammaB = new JSpinner(gammaModelB);
        this.spinGammaA = new JSpinner(gammaModelA);
        colorLevelPanel.add(this.spinGammaR);
        colorLevelPanel.add(this.spinGammaG);
        colorLevelPanel.add(this.spinGammaB);
        colorLevelPanel.add(this.spinGammaA);
        JPanel colorTunePanel = new JPanel();
        colorTunePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(strings.getProperty("group.hsb.caption"))));
        GridLayout gl2 = new GridLayout(3, 4);
        gl2.setHgap(3);
        gl2.setVgap(3);
        colorTunePanel.setLayout(gl2);
        colorTunePanel.add(new JLabel(strings.getProperty("hue"), 0));
        colorTunePanel.add(new JLabel(strings.getProperty("saturation"), 0));
        colorTunePanel.add(new JLabel(strings.getProperty("brightness"), 0));
        colorTunePanel.add(new JLabel(strings.getProperty("contrast"), 0));
        SpinnerNumberModel hsbModelH = new SpinnerNumberModel(0.0, -1.0, 1.0, 0.01);
        SpinnerNumberModel hsbModelS = new SpinnerNumberModel(0.0, -1.0, 1.0, 0.01);
        SpinnerNumberModel hsbModelB = new SpinnerNumberModel(0.0, -1.0, 1.0, 0.01);
        SpinnerNumberModel hsbModelC = new SpinnerNumberModel(0.0, -1.0, 1.0, 0.01);
        hsbModelH.addChangeListener(changeEventHandler);
        hsbModelS.addChangeListener(changeEventHandler);
        hsbModelB.addChangeListener(changeEventHandler);
        hsbModelC.addChangeListener(changeEventHandler);
        this.spinHue = new JSpinner(hsbModelH);
        this.spinSaturation = new JSpinner(hsbModelS);
        this.spinBrightness = new JSpinner(hsbModelB);
        this.spinContrast = new JSpinner(hsbModelC);
        colorTunePanel.add(this.spinHue);
        colorTunePanel.add(this.spinSaturation);
        colorTunePanel.add(this.spinBrightness);
        colorTunePanel.add(this.spinContrast);
        JSlider sliderHue = new JSlider();
        JSlider sliderSaturation = new JSlider();
        JSlider sliderBrightness = new JSlider();
        JSlider sliderContrast = new JSlider();
        sliderHue.setPreferredSize(this.spinHue.getPreferredSize());
        sliderSaturation.setPreferredSize(this.spinSaturation.getPreferredSize());
        sliderBrightness.setPreferredSize(this.spinBrightness.getPreferredSize());
        sliderContrast.setPreferredSize(this.spinContrast.getPreferredSize());
        colorTunePanel.add(sliderHue);
        colorTunePanel.add(sliderSaturation);
        colorTunePanel.add(sliderBrightness);
        colorTunePanel.add(sliderContrast);
        JSlider[] sliders = new JSlider[]{sliderHue, sliderSaturation, sliderBrightness, sliderContrast};
        JSpinner[] spinners = new JSpinner[]{this.spinHue, this.spinSaturation, this.spinBrightness, this.spinContrast};
        for (int idx = 0; idx < spinners.length; ++idx) {
            final JSlider sl = sliders[idx];
            final JSpinner sp = spinners[idx];
            SpinnerNumberModel spModel = (SpinnerNumberModel)sp.getModel();
            sl.setMinimum((int)(((Number)((Object)spModel.getMinimum())).floatValue() * 100.0f));
            sl.setMaximum((int)(((Number)((Object)spModel.getMaximum())).floatValue() * 100.0f));
            sl.setValue((int)(((Number)sp.getValue()).doubleValue() * 100.0));
            final Semaphore loopBlocker = new Semaphore(1);
            sl.addChangeListener(new ChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(ChangeEvent e) {
                    if (loopBlocker.tryAcquire()) {
                        try {
                            double rate = (double)sl.getValue() / 100.0;
                            sp.setValue(rate);
                        }
                        finally {
                            loopBlocker.release();
                        }
                    }
                }
            });
            sp.addChangeListener(new ChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(ChangeEvent e) {
                    if (loopBlocker.tryAcquire()) {
                        try {
                            int rate = (int)(((Number)sp.getValue()).doubleValue() * 100.0);
                            sl.setValue(rate);
                        }
                        finally {
                            loopBlocker.release();
                        }
                    }
                }
            });
        }
        ColorGroup colorGroup = layer.getColorGroup();
        JPanel colorGroupPanel = new JPanel();
        colorGroupPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(strings.getProperty("colorgroup"))));
        GridBagLayout gbl2 = new GridBagLayout();
        colorGroupPanel.setLayout(gbl2);
        GridBagConstraints gbc2 = new GridBagConstraints();
        JLabel lblColorGroup = new JLabel(strings.getProperty("group"), 4);
        this.cmbColorGroup = new JComboBox<ColorGroup>(colorGroups.toArray(new ColorGroup[colorGroups.size()]));
        this.cmbColorGroup.setSelectedItem(colorGroup);
        this.cmbColorGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorGroup selColorGroup = (ColorGroup)ColorDialogTabPanel.this.cmbColorGroup.getSelectedItem();
                ColorDialogTabPanel.this.chkColorGroupSync.setSelected(selColorGroup.isEnabled());
                ColorDialogTabPanel.this.fireColorGroupChangeEvent(layer);
            }
        });
        this.chkColorGroupSync = new JCheckBox(strings.getProperty("synchronized"));
        this.chkColorGroupSync.setSelected(layer.isInitSync());
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.gridwidth = 1;
        gbc2.gridheight = 1;
        gbc2.weightx = 0.0;
        gbc2.weighty = 0.0;
        gbc2.anchor = 17;
        gbc2.fill = 1;
        gbc2.ipadx = 0;
        gbc2.ipady = 0;
        gbc2.insets = new Insets(3, 3, 3, 3);
        colorGroupPanel.add((Component)lblColorGroup, gbc2);
        gbc2.gridx = 1;
        gbc2.gridy = 0;
        gbc2.gridwidth = 1;
        gbc2.gridheight = 1;
        gbc2.weightx = 1.0;
        gbc2.weighty = 0.0;
        colorGroupPanel.add((Component)this.cmbColorGroup, gbc2);
        gbc2.gridx = 2;
        gbc2.gridy = 0;
        gbc2.gridwidth = 0;
        gbc2.gridheight = 1;
        gbc2.weightx = 0.0;
        gbc2.weighty = 0.0;
        colorGroupPanel.add((Component)this.chkColorGroupSync, gbc2);
        if (colorGroupPanel != null) {
            container.add(colorGroupPanel);
        }
        container.add(colorLevelPanel);
        container.add(colorReplacePanel);
        container.add(colorTunePanel);
    }

    public void resetColor() {
        this.setColorConvertParameter(this.paramOrg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorConvertParameter(ColorConvertParameter param) {
        if (param == null) {
            throw new IllegalArgumentException();
        }
        this.paramOrg = param.clone();
        ColorConv colorReplace = param.getColorReplace();
        if (colorReplace == null) {
            colorReplace = ColorConv.NONE;
        }
        this.changeEventDisableSemaphore.incrementAndGet();
        try {
            this.cmbColorReplace.setSelectedItem(colorReplace);
            this.spinGray.setValue(param.getGrayLevel());
            this.spinOffsetR.setValue(param.getOffsetR());
            this.spinOffsetG.setValue(param.getOffsetG());
            this.spinOffsetB.setValue(param.getOffsetB());
            this.spinOffsetA.setValue(param.getOffsetA());
            this.spinFactorR.setValue(param.getFactorR());
            this.spinFactorG.setValue(param.getFactorG());
            this.spinFactorB.setValue(param.getFactorB());
            this.spinFactorA.setValue(param.getFactorA());
            this.spinGammaR.setValue(param.getGammaR());
            this.spinGammaG.setValue(param.getGammaG());
            this.spinGammaB.setValue(param.getGammaB());
            this.spinGammaA.setValue(param.getGammaA());
            this.spinHue.setValue(param.getHue());
            this.spinSaturation.setValue(param.getSaturation());
            this.spinBrightness.setValue(param.getBrightness());
            this.spinContrast.setValue(param.getContrast());
        }
        finally {
            this.changeEventDisableSemaphore.decrementAndGet();
        }
        this.chachedParam = param;
        this.firePropertyChange("colorConvertParameter", null, param);
    }

    public ColorConvertParameter getColorConvertParameter() {
        if (this.chachedParam != null) {
            return this.chachedParam;
        }
        ColorConvertParameter param = new ColorConvertParameter();
        param.setColorReplace((ColorConv)this.cmbColorReplace.getSelectedItem());
        param.setGrayLevel(((Number)this.spinGray.getValue()).floatValue());
        param.setOffsetR(((Number)this.spinOffsetR.getValue()).intValue());
        param.setOffsetG(((Number)this.spinOffsetG.getValue()).intValue());
        param.setOffsetB(((Number)this.spinOffsetB.getValue()).intValue());
        param.setOffsetA(((Number)this.spinOffsetA.getValue()).intValue());
        param.setFactorR(((Number)this.spinFactorR.getValue()).floatValue());
        param.setFactorG(((Number)this.spinFactorG.getValue()).floatValue());
        param.setFactorB(((Number)this.spinFactorB.getValue()).floatValue());
        param.setFactorA(((Number)this.spinFactorA.getValue()).floatValue());
        param.setGammaR(((Number)this.spinGammaR.getValue()).floatValue());
        param.setGammaG(((Number)this.spinGammaG.getValue()).floatValue());
        param.setGammaB(((Number)this.spinGammaB.getValue()).floatValue());
        param.setGammaA(((Number)this.spinGammaA.getValue()).floatValue());
        param.setHue(((Number)this.spinHue.getValue()).floatValue());
        param.setSaturation(((Number)this.spinSaturation.getValue()).floatValue());
        param.setBrightness(((Number)this.spinBrightness.getValue()).floatValue());
        param.setContrast(((Number)this.spinContrast.getValue()).floatValue());
        this.chachedParam = param;
        return param;
    }

    public boolean isColorConvertParameterModified() {
        return !this.paramOrg.equals(this.getColorConvertParameter());
    }

    public ColorGroup getColorGroup() {
        return (ColorGroup)this.cmbColorGroup.getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorGroup(ColorGroup colorGroup) {
        if (colorGroup == null) {
            colorGroup = ColorGroup.NA;
        }
        this.changeEventDisableSemaphore.incrementAndGet();
        try {
            this.cmbColorGroup.setSelectedItem(colorGroup);
        }
        finally {
            this.changeEventDisableSemaphore.decrementAndGet();
        }
    }

    public boolean isSyncColorGroup() {
        return this.chkColorGroupSync == null ? false : this.chkColorGroupSync.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncColorGroup(boolean selected) {
        if (this.chkColorGroupSync != null) {
            this.changeEventDisableSemaphore.incrementAndGet();
            try {
                this.chkColorGroupSync.setSelected(selected);
            }
            finally {
                this.changeEventDisableSemaphore.decrementAndGet();
            }
        }
    }
}

