/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.RecommendationURL;
import charactermanaj.ui.PartssetsTableModel;
import charactermanaj.ui.RecommendationTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RecommendationTableModel
extends AbstractTableModelWithComboBoxModel<RecommendationTableRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(PartssetsTableModel.class.getName());
    private static final String[] partssetsColumnNames;
    private static final int[] partssetsColumnWidths;

    public void adjustColumnModel(TableColumnModel columnModel) {
        for (int idx = 0; idx < partssetsColumnWidths.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth(partssetsColumnWidths[idx]);
        }
    }

    public void addNew() {
        this.addRow(new RecommendationTableRow(new RecommendationURL()));
    }

    @Override
    public int getColumnCount() {
        return partssetsColumnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return partssetsColumnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RecommendationTableRow rowModel = (RecommendationTableRow)this.elements.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rowModel.getLocalizedName();
            }
            case 1: {
                return rowModel.getURL();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        RecommendationTableRow rowModel = (RecommendationTableRow)this.elements.get(rowIndex);
        try {
            switch (columnIndex) {
                case 0: {
                    if (aValue == null || ((String)aValue).trim().length() <= 0) break;
                    rowModel.setLocalizedName((String)aValue);
                    break;
                }
                case 1: {
                    if (aValue == null || ((String)aValue).trim().length() <= 0) break;
                    rowModel.setURL((String)aValue);
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "value set failed. (" + rowIndex + ", " + columnIndex + "): " + aValue, ex);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.isEditable();
            }
            case 1: {
                return this.isEditable();
            }
        }
        return false;
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("languages/profileditdialog");
        partssetsColumnNames = new String[]{strings.getProperty("recommendations.column.displayName"), strings.getProperty("recommendations.column.url")};
        partssetsColumnWidths = new int[]{Integer.parseInt(strings.getProperty("recommendations.column.displayName.width")), Integer.parseInt(strings.getProperty("recommendations.column.url.width"))};
    }
}

