/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.ui.RecentCharactersDir;
import charactermanaj.ui.util.FileDropTarget;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectCharatersDirDialog
extends JDialog {
    private static final long serialVersionUID = -888834575856349442L;
    private static final Logger logger = Logger.getLogger(SelectCharatersDirDialog.class.getName());
    private final RecentCharactersDir recentCharactersDir;
    private File defaultCharactersDir;
    private File selectedCharacterDir;
    private boolean doNotAskAgain;
    private JComboBox combDir;
    private JCheckBox chkDoNotAsk;

    public File getDefaultCharactersDir() {
        return this.defaultCharactersDir;
    }

    public void setDefaultCharactersDir(File defaultCharactersDir) {
        this.defaultCharactersDir = defaultCharactersDir;
    }

    public File getSelectedCharacterDir() {
        return this.selectedCharacterDir;
    }

    public boolean isDoNotAskAgain() {
        return this.doNotAskAgain;
    }

    protected SelectCharatersDirDialog(JFrame parent, RecentCharactersDir recentCharactersDir) {
        super((Frame)parent, true);
        try {
            if (recentCharactersDir == null) {
                throw new IllegalArgumentException("recentCharactersDir\u306bnull\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
            }
            this.recentCharactersDir = recentCharactersDir;
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    SelectCharatersDirDialog.this.onClose();
                }
            });
            this.initComponent();
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, "\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u9078\u629e\u30c0\u30a4\u30a2\u30ed\u30b0\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            this.dispose();
            throw ex;
        }
    }

    private void initComponent() {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("languages/selectCharatersDirDialog");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(3, 3));
        AbstractAction actOk = new AbstractAction(strings.getProperty("btn.ok")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                SelectCharatersDirDialog.this.onOK();
            }
        };
        AbstractAction actClose = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                SelectCharatersDirDialog.this.onClose();
            }
        };
        AbstractAction actBrowse = new AbstractAction(strings.getProperty("btn.chooseDir")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                SelectCharatersDirDialog.this.onBrowse();
            }
        };
        AbstractAction actRemoveRecent = new AbstractAction(strings.getProperty("btn.clearRecentList")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                SelectCharatersDirDialog.this.onRemoveRecent();
            }
        };
        JButton btnRemoveRecent = new JButton(actRemoveRecent);
        final JButton btnOK = new JButton(actOk);
        JButton btnCancel = new JButton(actClose);
        JButton btnBroseForDir = new JButton(actBrowse);
        Toolkit tk = Toolkit.getDefaultToolkit();
        final JRootPane rootPane = this.getRootPane();
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JButton btn = (JButton)e.getSource();
                rootPane.setDefaultButton(btn);
            }

            public void focusLost(FocusEvent e) {
                rootPane.setDefaultButton(btnOK);
            }
        };
        rootPane.setDefaultButton(btnOK);
        InputMap im = rootPane.getInputMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "close");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "close");
        rootPane.getActionMap().put("close", actClose);
        btnRemoveRecent.addFocusListener(focusAdapter);
        btnOK.addFocusListener(focusAdapter);
        btnCancel.addFocusListener(focusAdapter);
        btnBroseForDir.addFocusListener(focusAdapter);
        JPanel dirPanel = new JPanel(new BorderLayout(3, 3));
        dirPanel.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 3));
        JLabel lbl = new JLabel(strings.getProperty("caption"), 0);
        lbl.setFont(lbl.getFont().deriveFont(1));
        lbl.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        Dimension dim = lbl.getPreferredSize();
        dim.width = Integer.parseInt(strings.getProperty("width"));
        lbl.setPreferredSize(dim);
        dirPanel.add((Component)lbl, "North");
        this.combDir = new JComboBox();
        this.combDir.setEditable(true);
        dirPanel.add((Component)this.combDir, "Center");
        dirPanel.add((Component)new JLabel(strings.getProperty("lbl.dir")), "West");
        dirPanel.add((Component)btnBroseForDir, "East");
        contentPane.add((Component)dirPanel, "North");
        JPanel btnPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        btnPanel.setLayout(gbl);
        this.chkDoNotAsk = new JCheckBox(strings.getProperty("chk.doNotAskAgein"));
        this.chkDoNotAsk.setSelected(this.recentCharactersDir.isDoNotAskAgain());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        btnPanel.add((Component)this.chkDoNotAsk, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        btnPanel.add((Component)btnRemoveRecent, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add(Box.createGlue(), gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 3 : 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        btnPanel.add((Component)btnOK, gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 2 : 3;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        btnPanel.add((Component)btnCancel, gbc);
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.ipadx = 32;
        gbc.ipady = 0;
        btnPanel.add(Box.createGlue(), gbc);
        this.setTitle(strings.getProperty("title"));
        this.setResizable(false);
        contentPane.add((Component)btnPanel, "South");
        new DropTarget(this, new FileDropTarget(){

            @Override
            protected void onDropFiles(List<File> dropFiles) {
                SelectCharatersDirDialog.this.setSelectFile(dropFiles);
            }

            @Override
            protected void onException(Exception ex) {
                ErrorMessageHelper.showErrorDialog(SelectCharatersDirDialog.this, ex);
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
    }

    protected void setSelectFile(List<File> dropFiles) {
        if (dropFiles.isEmpty()) {
            return;
        }
        File dropFile = dropFiles.get(0);
        if (!dropFile.exists() || !dropFile.isDirectory()) {
            return;
        }
        this.combDir.setSelectedItem(dropFile);
    }

    protected void checkCharacterNantokaDirs(File dirs) {
        if (dirs == null || !dirs.isDirectory() || !dirs.canWrite()) {
            return;
        }
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        for (File dir : dirs.listFiles()) {
            File characterIniFile;
            File characterXmlFile;
            if (!dir.isDirectory() || (characterXmlFile = new File(dir, "character.xml")).exists() || !(characterIniFile = new File(dir, "character.ini")).exists() || !characterIniFile.canWrite() || !dir.canWrite()) continue;
            try {
                persist.convertFromCharacterIni(characterIniFile, characterXmlFile);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "character.xml\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + characterXmlFile, ex);
            }
        }
    }

    protected void onClose() {
        this.selectedCharacterDir = null;
        this.dispose();
    }

    protected void onOK() {
        try {
            Object value = this.combDir.getSelectedItem();
            if (value != null && value instanceof String) {
                value = new File((String)value);
            }
            if (value != null && value instanceof File) {
                File file = (File)value;
                if (!file.exists()) {
                    boolean result = file.mkdirs();
                    logger.log(Level.INFO, "mkdirs(" + file + ") succeeded=" + result);
                }
                if (file.isDirectory()) {
                    this.checkCharacterNantokaDirs(file);
                    logger.log(Level.CONFIG, "selectedCharactersDir=" + file);
                    this.selectedCharacterDir = file;
                    this.doNotAskAgain = this.chkDoNotAsk.isSelected();
                    this.dispose();
                    return;
                }
            }
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onBrowse() {
        try {
            Object selectedItem = this.combDir.getSelectedItem();
            String directoryTxt = null;
            if (selectedItem != null) {
                directoryTxt = selectedItem.toString();
            }
            JFileChooser dirChooser = new JFileChooser(directoryTxt);
            dirChooser.setFileSelectionMode(1);
            if (dirChooser.showOpenDialog(this) != 0) {
                return;
            }
            File dir = dirChooser.getSelectedFile();
            if (dir != null) {
                this.combDir.setSelectedItem(dir);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onRemoveRecent() {
        try {
            Object current = this.combDir.getSelectedItem();
            this.recentCharactersDir.clrar();
            this.setRecents();
            if (current != null) {
                this.combDir.setSelectedItem(current);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void setRecents() {
        while (this.combDir.getItemCount() > 0) {
            this.combDir.removeItemAt(0);
        }
        ArrayList<File> priorityDirs = new ArrayList<File>();
        File lastUseCatacterDir = this.recentCharactersDir.getLastUseCharacterDir();
        if (lastUseCatacterDir != null && this.defaultCharactersDir != null && !lastUseCatacterDir.equals(this.defaultCharactersDir)) {
            this.combDir.addItem(lastUseCatacterDir);
            priorityDirs.add(lastUseCatacterDir);
        }
        if (this.defaultCharactersDir != null) {
            this.combDir.addItem(this.defaultCharactersDir);
            priorityDirs.add(this.defaultCharactersDir);
        }
        for (File charactersDir : this.recentCharactersDir.getRecentCharacterDirs()) {
            if (charactersDir == null || priorityDirs.contains(charactersDir)) continue;
            this.combDir.addItem(charactersDir);
        }
        if (this.combDir.getItemCount() > 0) {
            this.combDir.setSelectedIndex(0);
        }
    }

    public static File getCharacterDir(File defaultCharacterDir) {
        RecentCharactersDir recentChars;
        try {
            recentChars = RecentCharactersDir.load();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "\u6700\u5f8c\u306b\u4f7f\u7528\u3057\u305f\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u60c5\u5831\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            recentChars = null;
        }
        if (recentChars == null) {
            recentChars = new RecentCharactersDir();
        }
        logger.log(Level.CONFIG, "RecentCharacterDirs.doNotAskAgain=" + recentChars.isDoNotAskAgain());
        if (recentChars.isDoNotAskAgain()) {
            File recentCharDir = recentChars.getLastUseCharacterDir();
            if (recentCharDir != null && recentCharDir.exists() && recentCharDir.isDirectory()) {
                return recentCharDir;
            }
            recentChars.setDoNotAskAgain(false);
        }
        SelectCharatersDirDialog dlg = new SelectCharatersDirDialog(null, recentChars);
        dlg.setDefaultCharactersDir(defaultCharacterDir);
        dlg.setRecents();
        dlg.setVisible(true);
        File selectedCharacterDir = dlg.getSelectedCharacterDir();
        if (selectedCharacterDir != null) {
            recentChars.setLastUseCharacterDir(selectedCharacterDir);
            try {
                recentChars.setDoNotAskAgain(dlg.isDoNotAskAgain());
                recentChars.saveRecents();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "\u6700\u5f8c\u306b\u4f7f\u7528\u3057\u305f\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u60c5\u5831\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            }
        }
        return selectedCharacterDir;
    }
}

