/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;

final class ExceptionDiagnosis
implements Serializable {
    int stackLineHash;
    int lineNumberHash;
    String hexString = "";
    Throwable th;
    private static final long serialVersionUID = 453958937114285988L;

    ExceptionDiagnosis(Throwable th) {
        this(th, new String[0]);
    }

    ExceptionDiagnosis(Throwable th, String[] inclusionFilter) {
        this.th = th;
        StackTraceElement[] stackTrace = th.getStackTrace();
        this.stackLineHash = 0;
        this.lineNumberHash = 0;
        block0: for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement line = stackTrace[i];
            String[] arr$ = inclusionFilter;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String filter = arr$[i$];
                if (!line.getClassName().startsWith(filter)) continue;
                int hash = line.getClassName().hashCode() + line.getMethodName().hashCode();
                this.stackLineHash = 31 * this.stackLineHash + hash;
                this.lineNumberHash = 31 * this.lineNumberHash + line.getLineNumber();
                continue block0;
            }
        }
        this.hexString = this.hexString + this.toHexString(this.stackLineHash) + "-" + this.toHexString(this.lineNumberHash);
        if (null != th.getCause()) {
            this.hexString = this.hexString + " " + new ExceptionDiagnosis(th.getCause(), inclusionFilter).asHexString();
        }
    }

    int getStackLineHash() {
        return this.stackLineHash;
    }

    String getStackLineHashAsHex() {
        return this.toHexString(this.stackLineHash);
    }

    int getLineNumberHash() {
        return this.lineNumberHash;
    }

    String getLineNumberHashAsHex() {
        return this.toHexString(this.lineNumberHash);
    }

    String asHexString() {
        return this.hexString;
    }

    private String toHexString(int value) {
        String str = "0000000" + Integer.toHexString(value);
        return str.substring(str.length() - 8, str.length());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionDiagnosis that = (ExceptionDiagnosis)o;
        if (this.lineNumberHash != that.lineNumberHash) {
            return false;
        }
        return this.stackLineHash == that.stackLineHash;
    }

    public int hashCode() {
        int result = this.stackLineHash;
        result = 31 * result + this.lineNumberHash;
        return result;
    }

    public String toString() {
        return "ExceptionDiagnosis{stackLineHash=" + this.stackLineHash + ", lineNumberHash=" + this.lineNumberHash + '}';
    }
}

