/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log;

import com.google.appengine.api.log.LogQuery;
import com.google.appengine.api.log.LogQueryResult;
import com.google.appengine.api.log.LogService;
import com.google.appengine.api.log.LogServiceException;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.logservice.LogServicePb;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

final class LogServiceImpl
implements LogService {
    static final String PACKAGE = "logservice";
    static final String READ_RPC_NAME = "Read";

    LogServiceImpl() {
    }

    public LogQueryResult fetch(LogQuery query) {
        try {
            return this.fetchAsync(query).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof LogServiceException) {
                throw (LogServiceException)e.getCause();
            }
            throw new LogServiceException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new LogServiceException(e.getMessage());
        }
    }

    Future<LogQueryResult> fetchAsync(LogQuery query) {
        String[] convertedVersionIds;
        Long endTimeUs;
        LogServicePb.LogReadRequest request = new LogServicePb.LogReadRequest();
        request.setAppId(ApiProxy.getCurrentEnvironment().getAppId());
        Long startTimeUs = query.getStartTimeUsec();
        if (startTimeUs != null) {
            request.setStartTime(startTimeUs);
        }
        if ((endTimeUs = query.getEndTimeUsec()) != null) {
            request.setEndTime(endTimeUs);
        }
        request.setCount(query.getBatchSize().intValue());
        if (query.getMinLogLevel() != null) {
            request.setMinimumLogLevel(query.getMinLogLevel().ordinal());
        }
        request.setIncludeIncomplete(query.getIncludeIncomplete());
        request.setIncludeAppLogs(query.getIncludeAppLogs());
        List<String> versionIds = query.getMajorVersionIds();
        if (versionIds.isEmpty()) {
            String currentVersionId = ApiProxy.getCurrentEnvironment().getVersionId();
            String majorVersionId = currentVersionId.split("\\.")[0];
            convertedVersionIds = new String[]{majorVersionId};
        } else {
            convertedVersionIds = versionIds.toArray(new String[0]);
        }
        for (String versionId : convertedVersionIds) {
            request.addVersionId(versionId);
        }
        String offset = query.getOffset();
        if (offset != null) {
            request.setOffset(LogQueryResult.parseOffset(offset));
        }
        final LogQuery finalizedQuery = query;
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        Future<byte[]> responseBytes = ApiProxy.makeAsyncCall(PACKAGE, READ_RPC_NAME, request.toByteArray(), apiConfig);
        return new FutureWrapper<byte[], LogQueryResult>(responseBytes){

            @Override
            protected LogQueryResult wrap(byte[] responseBytes) {
                LogServicePb.LogReadResponse response = new LogServicePb.LogReadResponse();
                response.mergeFrom(responseBytes);
                return new LogQueryResult(response, finalizedQuery);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof ApiProxy.ApplicationException) {
                    ApiProxy.ApplicationException e = (ApiProxy.ApplicationException)cause;
                    return new LogServiceException(e.getMessage());
                }
                return cause;
            }
        };
    }
}

