/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.FieldChecker;
import com.google.appengine.api.search.IndexChecker;
import com.google.appengine.api.search.Preconditions;
import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.SortSpecChecker;
import com.google.appengine.api.search.query.QueryTreeBuilder;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import java.util.List;

public final class SearchRequestChecker {
    public static final int MAXIMUM_OFFSET = 1000;
    public static final int MAXIMUM_LIMIT = 800;
    public static final int DEFAULT_LIMIT = 20;
    public static final int MAXIMUM_MATCHED_COUNT_ACCURACY = 10000;
    public static final int DEFAULT_MATCHED_COUNT_ACCURACY = 100;
    public static final int MAXIMUM_NUMBER_OF_FIELDS_TO_RETURN = 100;

    public static String checkQuery(String query) {
        Preconditions.checkNotNull(query, "query cannot be null");
        try {
            new QueryTreeBuilder().parse(query);
        }
        catch (RecognitionException e) {
            throw new SearchQueryException("Unable to parse query: " + e.getMessage());
        }
        return query;
    }

    public static int checkLimit(int limit) {
        Preconditions.checkArgument(limit >= 1 && limit <= 800, "The limit %d must be between 1 and %d", limit, 800);
        return limit;
    }

    public static Integer checkOffset(Integer offset) {
        if (offset != null) {
            Preconditions.checkArgument(offset >= 0 && offset <= 1000, "The offset %d must be between 0 and %d", offset, 1000);
        }
        return offset;
    }

    public static int checkMatchedCountAccuracy(int matchedCountAccuracy) {
        Preconditions.checkArgument(matchedCountAccuracy >= 1 && matchedCountAccuracy <= 10000, "The matched count accuracy %d must be between 1 and %d", matchedCountAccuracy, 10000);
        return matchedCountAccuracy;
    }

    public static List<String> checkFieldNames(List<String> fieldNames) {
        SearchRequestChecker.checkNumberOfFields(fieldNames.size());
        for (String fieldName : fieldNames) {
            FieldChecker.checkFieldName(fieldName);
        }
        return fieldNames;
    }

    private static List<SearchServicePb.FieldSpec.Expression> checkExpressions(List<SearchServicePb.FieldSpec.Expression> expressions) {
        SearchRequestChecker.checkNumberOfFields(expressions.size());
        for (SearchServicePb.FieldSpec.Expression expression : expressions) {
            FieldChecker.checkFieldName(expression.getName());
            FieldChecker.checkExpression(expression.getExpression());
        }
        return expressions;
    }

    private static void checkNumberOfFields(int numberOfFields) {
        Preconditions.checkArgument(numberOfFields <= 100, "number of fields to return %d greater than %d", numberOfFields, 100);
    }

    public static String checkCursor(String cursor) {
        if (cursor != null) {
            Preconditions.checkArgument(!cursor.isEmpty(), "cursor cannot be empty");
        }
        return cursor;
    }

    public static SearchServicePb.SearchParams checkValid(SearchServicePb.SearchParams params) {
        IndexChecker.checkValid(params.getIndexSpec());
        SearchRequestChecker.checkQuery(params.getQuery());
        if (params.hasCursor()) {
            SearchRequestChecker.checkCursor(params.getCursor());
        }
        SearchRequestChecker.checkOffset(params.getOffset());
        SearchRequestChecker.checkLimit(params.getLimit());
        if (params.hasMatchedCountAccuracy()) {
            SearchRequestChecker.checkMatchedCountAccuracy(params.getMatchedCountAccuracy());
        }
        for (SearchServicePb.SortSpec sortSpec : params.getSortSpecList()) {
            SortSpecChecker.checkValid(sortSpec);
        }
        if (params.hasScorerSpec()) {
            SortSpecChecker.checkValid(params.getScorerSpec());
        }
        if (params.hasKeysOnly()) {
            Preconditions.checkArgument(params.getFieldSpec().getExpressionCount() == 0, "if IDs only is requested expression to return must be empty");
            Preconditions.checkArgument(params.getFieldSpec().getNameCount() == 0, "if IDs only is requested expression to return must be empty");
        }
        SearchRequestChecker.checkFieldNames(params.getFieldSpec().getNameList());
        SearchRequestChecker.checkExpressions(params.getFieldSpec().getExpressionList());
        return params;
    }
}

