/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.Preconditions;
import com.google.appengine.api.search.SearchResult;
import com.google.appengine.api.search.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class SearchResponse
implements Iterable<SearchResult>,
Serializable {
    private static final long serialVersionUID = 1189234703739911898L;
    private static final int MAX_RESULTS_TO_STRING = 10;
    private final OperationResult operationResult;
    private final Collection<SearchResult> results;
    private final long matchedCount;
    private final int returnedCount;
    private final String cursor;

    SearchResponse(OperationResult operationResult, Collection<SearchResult> results, long matchedCount, int returnedCount, String cursor) {
        this.operationResult = Preconditions.checkNotNull(operationResult, "operation result cannot be null");
        this.results = Collections.unmodifiableCollection(Preconditions.checkNotNull(results, "search results cannot be null"));
        this.matchedCount = matchedCount;
        this.returnedCount = returnedCount;
        this.cursor = cursor;
    }

    @Override
    public Iterator<SearchResult> iterator() {
        return this.results.iterator();
    }

    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    public long getMatchedCount() {
        return this.matchedCount;
    }

    public int getReturnedCount() {
        return this.returnedCount;
    }

    public Collection<SearchResult> getResults() {
        return this.results;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String toString() {
        return String.format("SearchResponse(operationResult=%s, results=%s, matchedCount=%d, returnedCount=%d, cursor=%s)", this.operationResult, Util.iterableToString(this.results, 10), this.matchedCount, this.returnedCount, this.cursor);
    }
}

