/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nullable;

@GwtCompatible
@Beta
public final class Enums {
    private Enums() {
    }

    public static <T extends Enum<T>> Function<String, T> valueOfFunction(Class<T> enumClass) {
        return new ValueOfFunction(enumClass);
    }

    @GoogleInternal
    public static <T extends Enum<T>> Converter<String, T> stringConverter(final Class<T> enumClass) {
        Preconditions.checkNotNull(enumClass);
        return new Converter<String, T>(){

            @Override
            public T convert(String value) {
                return Enum.valueOf(enumClass, value);
            }

            @Override
            public String reverse(T enumValue) {
                return ((Enum)enumValue).name();
            }
        };
    }

    private static final class ValueOfFunction<T extends Enum<T>>
    implements Function<String, T>,
    Serializable {
        private final Class<T> enumClass;
        private static final long serialVersionUID = 0L;

        private ValueOfFunction(Class<T> enumClass) {
            this.enumClass = Preconditions.checkNotNull(enumClass);
        }

        @Override
        public T apply(String value) {
            try {
                return Enum.valueOf(this.enumClass, value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof ValueOfFunction && this.enumClass.equals(((ValueOfFunction)obj).enumClass);
        }

        public int hashCode() {
            return this.enumClass.hashCode();
        }

        public String toString() {
            return "Enums.valueOf(" + this.enumClass + ")";
        }
    }
}

