/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.xml;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.escape.CharEscaper;
import com.google.appengine.repackaged.com.google.common.escape.Escapers;

@Beta
@GwtCompatible
public class XmlEscapers {
    private static final char MIN_ASCII_CONTROL_CHAR = '\u0000';
    private static final char MAX_ASCII_CONTROL_CHAR = '\u001f';
    private static final CharEscaper XML_ESCAPER;
    private static final CharEscaper XML_CONTENT_ESCAPER;

    private XmlEscapers() {
    }

    public static CharEscaper xmlEscaper() {
        return XML_ESCAPER;
    }

    public static CharEscaper xmlContentEscaper() {
        return XML_CONTENT_ESCAPER;
    }

    static {
        Escapers.Builder builder = Escapers.builder();
        builder.setSafeRange('\u0000', '\uffff');
        builder.setUnsafeReplacement("");
        for (char c = '\u0000'; c <= '\u001f'; c = (char)((char)(c + 1))) {
            if (c == 9 || c == 10 || c == 13) continue;
            builder.addEscape(c, "");
        }
        builder.addEscape('&', "&amp;");
        builder.addEscape('<', "&lt;");
        builder.addEscape('>', "&gt;");
        XML_CONTENT_ESCAPER = (CharEscaper)builder.build();
        builder.addEscape('\'', "&apos;");
        builder.addEscape('\"', "&quot;");
        XML_ESCAPER = (CharEscaper)builder.build();
    }
}

