<?php
/**
*  ե졼Υᥤ󥯥饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_Framework
{
	/*
	 *	ե졼ư
	 */
	public static function run()
	{
		try{
			//=======================================
			// ॾ
			//
			$default_tz = charcoal_Profile::getString( 'DEFAULT_TIMEZONE' );
			date_default_timezone_set( $default_tz );
//			ini_set( 'date.timezone', CHARCOAL_TIMEZONE );

			//=======================================
			// ν
			//

			// ץեꤵƤ
			$logger_names = charcoal_Profile::getArray( 'LOG_LOGGERS' );

			// Ͽ
			foreach( $logger_names as $key ){
				$logger = charcoal_LoggerFactory::create( $key );
				charcoal_Logger::append( $key, $logger );
			}

			// Ϥ򳫻
			charcoal_Logger::init();

			// ưå
			log_info( 'system,config', '===========================================================', __FILE__, __LINE__ );
			log_info( 'system,config', ' CHARCOAL framework version 1.0 (c)sazysoft,stk2k          ', __FILE__, __LINE__ );
			log_info( 'system,config', '===========================================================', __FILE__, __LINE__ );

			log_info( 'system', 'charcoalե졼򳫻Ϥޤ', __FILE__, __LINE__ );


			//=======================================
			// 饹Ͽ
			//
			$class_loaders = charcoal_Profile::getArray('CLASS_LOADERS');
			if ( $class_loaders && is_array($class_loaders) ) {
				foreach( $class_loaders as $loader_name ) 	{
					$loader = charcoal_ClassLoaderFactory::create( $loader_name );
					charcoal_ClassLoader::addClassLoader( $loader );
				}
			}

			//=======================================
			// åϥɥκ
			//

			if ( charcoal_Profile::getBoolean('USE_SESSION') ) {
				log_info( 'system', 'åϥɥκ򳫻Ϥޤ', __FILE__, __LINE__ );

				// åϥɥ̾μ
				$session_handler_name = charcoal_Profile::getString( 'SESSION_HANDLER_NAME' );

				// åϥɥκ
				$session_handler = charcoal_SessionHandlerFactory::create( $session_handler_name );

				log_info( 'system', 'åϥɥκλޤ', __FILE__, __LINE__ );
			}

			//=======================================
			// Requestѥ᡼μ
			//

			log_info( 'system', 'Requestѥ᡼βϤ򳫻Ϥޤ', __FILE__, __LINE__ );

			// Request֥Ȥ
			$request = new charcoal_Request();

			$proc_key = $request->get( PROC_KEYWORD );

			log_info( 'system', "ץ㥭[$proc_key]Ǥ", __FILE__, __LINE__ );

			//=======================================
			// URLޥåԥ
			//

			if ( charcoal_Profile::getBoolean('USE_URL_MAPPING') ) {
				log_info( 'system', 'URLޥåԥ󥰤򳫻Ϥޤ', __FILE__, __LINE__ );

				// URLޥåѡ̾
				$url_mapper_name = charcoal_Profile::getString('URL_MAPPER' );

				// URLޥåѡ
				$url_mapper = charcoal_URLMapperFactory::create( $url_mapper_name );

				// ޥåԥ󥰼¹
				$url_mapper->mapURL( $request );

				$proc_key = $request->get( PROC_KEYWORD );

				log_info( 'system', "ץ㥭[$proc_key]Ǥ", __FILE__, __LINE__ );
			}

			//=======================================
			// ꥯȥǥѥå
			//

			log_info( 'system', 'Dispatch򳫻Ϥޤ', __FILE__, __LINE__ );

			// ǥѥå̾ե뤫
			$dispacher_name = charcoal_Profile::getString( 'DISPATCHER' );

			// ǥѥå
			$dispatcher = charcoal_DispatcherFactory::create( $dispacher_name );

			// ǥѥå
			$proc_key = $dispatcher->dispatch( $request );

			log_info( 'system', "Dispatchλޤǥѥå=[$proc_key]", __FILE__, __LINE__ );

			//=======================================
			// Procedureκ
			//

			log_info( 'system', "ץ[$proc_key]ޤ", __FILE__, __LINE__ );

			// ץ
			list( $procedure, $proc_name ) = charcoal_ProcedureFactory::create( $proc_key );

			log_info( 'system', "ץ[$proc_name]ޤ", __FILE__, __LINE__ );

			//=======================================
			// ƥʤκȵư
			//

			log_info( 'system', 'DIƥʤκ򳫻Ϥޤ', __FILE__, __LINE__ );

			// DIƥʤ
			charcoal_DIContainer::createContainer( $procedure );

			//=======================================
			// Responseκ
			//

			log_info( 'system', 'Response֥Ȥޤ', __FILE__, __LINE__ );

			// Request֥Ȥ
			$response = new charcoal_Response();

			//=======================================
			// ProcedureContextκ
			//

			log_info( 'system', 'ProcedureContext֥Ȥޤ', __FILE__, __LINE__ );

			// å
			$session = new charcoal_Session();

			// ProcedureContext֥Ȥ
			$context = new charcoal_ProcedureContext( $proc_name, $procedure, $session );

			//=======================================
			// åγ
			//
			if ( charcoal_Profile::getBoolean('USE_SESSION') ) {
				$session->start();
				$session->restore();
			}

			//=======================================
			// Procedureμ¹
			//

			log_info( 'system', 'ץ[$proc_name]¹Ԥޤ', __FILE__, __LINE__ );

			// ץμ¹
			$procedure->execute( $request, $context, $response );

			log_info( 'system', 'ץ[$proc_name]¹Ԥޤ', __FILE__, __LINE__ );

			//=======================================
			// λ
			//

			// å¸
			if ( charcoal_Profile::getBoolean('USE_SESSION') ) {
				$session->save();
				$session->close();
			}

			//=======================================
			// ƥʤ˴
			//

			log_info( 'system', 'DIƥʤ˴ޤ', __FILE__, __LINE__ );

			charcoal_DIContainer::destroy();

			// λå
			log_info( 'system', 'charcoalե졼λޤ', __FILE__, __LINE__ );
		}
		catch ( charcoal_HttpException $e )
		{
			// ơ
			$status = $e->getStatusCode();

			// 桼error_docs򸡺
			$html_file = charcoal_ResourceLocator::getWebAppPath( 'error_docs' , "$status.html" );

			if ( !is_file($html_file) ){
				// ʤХǥեȤerror_docs򸡺
				$html_file = charcoal_ResourceLocator::getSystemPath( 'error_docs' , "$status.html" );
			}

			if ( is_file($html_file) ){
				// ɤ߹ߤɽ
				readfile( $html_file );
				print "<br>";
			}
			else{
				// Errorɥȥե뤬ʤ
				log_warning( 'system,error', "顼ɥ($html_file)¸ߤޤ", __FILE__, __LINE__ );
			}

			// إå
			$header_msg_array = array(
					'401' => 'Unauthorized',
					'403' => 'Forbidden',
					'404' => 'Not Found',
					'500' => 'Internal Server Error',
				);
			$header_msg = $header_msg_array[$status];
			$message = "HTTP/1.0 $status $header_msg";
			header( $message );

			// 顼
			log_error( 'system,error', $message, __FILE__, __LINE__ );
		}
		catch ( charcoal_Exception $e ){

			$cause_list = $e->getCauseList();

			$cause_list[] = new charcoal_Exception( 'Framework#run() failed', $e );

			include( 'core/exception_list.php' );

		}
	}
}
