<?php
/**
* եȥꥯ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_LoggerFactory 
{
	/*
	 * 
	 */
	public static function create( $logger_name )
	{
		if ( strlen("$logger_name") == 0 ){
			throw new ParameterException();
		}

		// ץХ
		$provider = charcoal_ConfigProviderFactory::create();

		// ͳǼѥ֥Ȥ
		$config= new charcoal_Config();

		// 롼ȥѥ
		$config_root_webapp = charcoal_ResourceLocator::getWebAppPath('config');
		$config_root_system = charcoal_ResourceLocator::getSystemPath('config');

		// եɤ߹
		$config_name = "loggers/$logger_name.logger";
		$config->append( $provider->load( $config_root_webapp, $config_name ) );
		$config->append( $provider->load( $config_root_system, $config_name ) );

		// 饹̾
		$class_name = $config->getString( 'class_name' );

		// 饹̾γǧ
		if ( !$class_name || !charcoal_ClassUtil::validateClassName($class_name) ){
			throw new charcoal_LoggerConfigException( 'class_name', "invalid class name:$class_name" );
		}

		// Υ󥹥
		$logger = charcoal_ClassUtil::newInstance( $class_name );

		// 󥹥󥹤ILogger󥿥եƤ뤫ǧ
		if ( !($logger instanceof charcoal_ILogger) ){
			// 㳰
			throw new charcoal_InterfaceImplementException( $class_name, "charcoal_ILogger" );
		}

		// 
		$logger->init( $config );

		// ɤֵ
		return $logger;
	}
}
