<?php
/**
* ѥå饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Stack extends Object
{
	private $_data;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_data = array();
	}

	/*
	 *	ƬǤ
	 */
	public function getHead()
	{
		$cnt = count($this->_data);
		if ( $cnt > 0 ){
			return $this->_data[0];
		}
		throw new EmptyStackException( $this );
	}

	/*
	 *	ǸǤ
	 */
	public function getTail()
	{
		$cnt = count($this->_data);
		if ( $cnt > 0 ){
			return $this->_data[$cnt-1];
		}
		throw new EmptyStackException( $this );
	}

	/*
	 *	
	 */
	public function isEmpty()
	{
		return count($this->_data) === 0;
	}

	/*
	 *	ǿ
	 */
	public function count()
	{
		return count($this->_data);
	}

	/*
	 *	ƤǤ
	 */
	public function clear()
	{
		$this->_data = array();
	}

	/*
	 *	Ǥɲ
	 */
	public function push( $item )
	{
		if ( is_null($item) ){
			throw new NullPointerException();
		}
		return array_push( $this->_data, $item );
	}

	/*
	 *	Ǥ
	 */
	public function pop()
	{
		$item = array_pop( $this->_data );
		if ( !$item ){
			throw new EmptyStackException( $this );
		}
		return $item;
	}

	/**
	 *	
	 */
	public function dump()
	{
		array_dump( $this->_data );
	}

}
return __FILE__;
