<?php
/**
* ѥ󤯤ꥹȥݡͥ
*
* PHP version 5
*
* @package    components.charcoal
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class BreadcrumbList extends Object implements IComponent
{
	var $_breadcrumbs;
	var $_format;
	var $_separator;

	const DEFAULT_FORMAT      = '<a href="%URL%">%CAPTION%</a>';
	const DEFAULT_SEPARATOR   = '&nbsp;&gt;&nbsp;';

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_breadcrumbs = array();
	}

	/*
	 * ݡͥ̾
	 */
	public function getComponentName()
	{
		return "BreadcrumbList Component";
	}

	/*
	 * ݡͥȤ
	 */
	public function init( Config $config )
	{
		$this->_breadcrumbs = $config->getAssoc( s('breadcrumbs') );
		$this->_format 		= $config->getString( s('format') );
		$this->_separator 	= $config->getString( s('separator') );
	}

	/*
	 * ѥ󤯤ꥹȤ
	 */
	public function makeList( $breadcrumbs )
	{
		// NULLå
		if ( !$breadcrumbs ){
			throw new NullPointerException( "breadcrumbs" );
		}

		// å
		if ( !is_array($breadcrumbs) ){
			throw new ParameterException( "breadcrumbs", $breadcrumbs, "not array" );
		}

		// LinkerݡͥȤ
		$linker = DIContainer::getComponent( s('charcoal:Linker') );

		// ѥ󤯤
		$out = "";

		// եޥåȤ̵ʤ顢ǥեȤΥեޥåȤ
		$format = $this->_format ? $this->_format : self::DEFAULT_FORMAT;

		// ѥ졼̵ʤ顢ǥեȤΥѥ졼
		$separator = $this->_separator ? $this->_separator : self::DEFAULT_SEPARATOR;

		// ̤˽
		foreach( $breadcrumbs as $b ){
			// ѥ󤯤
			$setting = $this->_breadcrumbs[ $b ];
			// ꤬
			if ( $setting ){
				// ץ̾
				$caption = $setting[ 'caption' ];
				$link = $setting[ 'link' ];

				// LinkerݡͥȤʪɥ쥹Ѵ
				if ( $linker->hasLink($link) ){
					$url = $linker->getLink( $link );
				}
				else{
					$url = $link;
				}

				// ޥŸ
				$str = $format;
				$str = str_replace( "%CAPTION%", $caption, $str );
				$str = str_replace( "%URL%", $url, $str );

				// ɲ
				if ( strlen($out) > 0 ){
					$out .= $separator;
				}
				$out .= $str;
			}
		}

		return $out;
	}
}
return __FILE__;
